class Q_EXPORT QColor
{
public:
    enum Spec {
	Rgb,
	Hsv
    };

    QColor();
    QColor( int r, int g, int b );
    QColor( int x, int y, int z, Spec s );
    QColor( const char *name );
    QColor( const QColor& c );

    bool   isValid() const;
    bool   isDirty() const;

    QString name() const prop( name );
    void   setNamedColor( const QString& name ) prop(name);

    void   rgb( int *r, int *g, int *b ) const;
    void   setRgb( int r, int g, int b );

    int	   red()    const prop(red);
    int	   green()  const prop(green);
    int	   blue()   const prop(blue);

    void   hsv( int *h, int *s, int *v ) const;
    void   setHsv( int h, int s, int v );

    QColor light( int f = 150 ) const;
    QColor dark( int f = 200 )	const;

    static bool lazyAlloc();
    static void setLazyAlloc( bool );
    uint   alloc() prop(alloc);
    uint   pixel()  const prop(pixel);

    static int  maxColors();
    static int  numBitPlanes();

    static int  enterAllocContext();
    static void leaveAllocContext();
    static int  currentAllocContext();
    static void destroyAllocContext( int );
};
