//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;

	/// <remarks>
	///  @brief Class to allow for atomic file I/O, as well as utility functions.
	///  The KSaveFile class has been made to write out changes to an existing
	///  file atomically. This means that either <b>ALL</b> changes will be written
	///  to the file, or <b>NO</b> changes have been written, and the original file
	///  (if any) has been unchanged. This is useful if you have lots of 
	///  time-consuming processing to perform during which an interruption could
	///  occur, or if any error in the file structure will cause the entire file
	///  to be corrupt.
	///  When you create a KSaveFile for a given file, a temporary file is instead
	///  created and all your I/O occurs in the save file. Once you call finalize()
	///  the temporary file is renamed to the target file, so that all your changes
	///  happen at once. If abort() is called then the temporary file is removed and
	///  the target file is untouched. KSaveFile derives from QFile so you can use
	///  it just as you would a normal QFile.
	///  This class also includes several static utility functions available that
	///  can help ensure data integrity. See the individual functions for details.
	///  Here is a quick example of how to use KSaveFile:
	///  First we create the KSaveFile and open it.
	///  @code
	///  KSaveFile saveFile;
	///  saveFile.setFileName("/lib/foo/bar.dat");
	///  if ( !saveFile.open() ) {
	///      //Handle error
	///  }
	///  @endcode
	///  At this point the file "/lib/foo/bar.dat" has not been altered in any way.
	///  Now, let's write out some data to the file.
	///  @code
	///  QTextStream stream ( &saveFile );
	///  stream << "Add some data.";
	///  // Perform long processing
	///  stream << "Add some more data.";
	///  stream.flush();
	///  @endcode
	///  Even after writing this data, the target file "/lib/foo/bar.dat" still has
	///  not been altered in any way. Now that we are done writing our data, we can
	///  write out all the changes that we have made by calling finalize().
	///  @code
	///  if ( !saveFile.finalize() ) {
	///      //Handle error
	///  }
	///  @endcode
	///  If a user interruption or error occurred while we were writing out our
	///  changes, we would instead call abort() to cancel all the I/O without
	///  affecting the target file.
	/// </remarks>		<author> Waldo Bastian <bastian@kde.org>
	///  </author>
	/// 		<short>    @brief Class to allow for atomic file I/O, as well as utility functions.</short>
	/// 		<see> QFile</see>

	[SmokeClass("KSaveFile")]
	public class KSaveFile : QFile, IDisposable {
 		protected KSaveFile(Type dummy) : base((Type) null) {}
		protected new void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KSaveFile), this);
		}
		private static SmokeInvocation staticInterceptor = null;
		static KSaveFile() {
			staticInterceptor = new SmokeInvocation(typeof(KSaveFile), null);
		}
		/// <remarks>
		///  Default constructor.
		///      </remarks>		<short>    Default constructor.</short>
		public KSaveFile() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KSaveFile", "KSaveFile()", typeof(void));
		}
		/// <remarks>
		///  Creates a new KSaveFile and sets the target file to <code>filename.</code>
		/// <param> name="filename" the path of the file
		/// </param><param> name="componentData" The KComponentData to use for the temporary file.
		///      </param></remarks>		<short>    Creates a new KSaveFile and sets the target file to <code>filename.</code></short>
		public KSaveFile(string filename, KComponentData componentData) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KSaveFile$#", "KSaveFile(const QString&, const KComponentData&)", typeof(void), typeof(string), filename, typeof(KComponentData), componentData);
		}
		public KSaveFile(string filename) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KSaveFile$", "KSaveFile(const QString&)", typeof(void), typeof(string), filename);
		}
		/// <remarks>
		///  @brief Set the target filename for the save file.
		///  You must use this to set the filename of the target file if you do
		///  not use the contructor that does so.
		/// <param> name="filename" Name of the target file.
		///      </param></remarks>		<short>    @brief Set the target filename for the save file.</short>
		public new void SetFileName(string filename) {
			interceptor.Invoke("setFileName$", "setFileName(const QString&)", typeof(void), typeof(string), filename);
		}
		/// <remarks>
		///  @brief Returns the name of the target file.
		///  This function returns the name of the target file, or an empty
		///  string if it has not yet been set.
		/// </remarks>		<return> The name of the target file.
		///      </return>
		/// 		<short>    @brief Returns the name of the target file.</short>
		public new string FileName() {
			return (string) interceptor.Invoke("fileName", "fileName() const", typeof(string));
		}
		/// <remarks>
		///  @brief Returns the last error that occurred.
		///  Use this function to check for errors.
		/// </remarks>		<return> The last error that occurred, or QFile.NoError.
		///      </return>
		/// 		<short>    @brief Returns the last error that occurred.</short>
		public new QFile.FileError Error() {
			return (QFile.FileError) interceptor.Invoke("error", "error() const", typeof(QFile.FileError));
		}
		/// <remarks>
		///  @brief Returns a human-readable description of the last error.
		///  Use this function to get a human-readable description of the
		///  last error that occurred.
		/// </remarks>		<return> A string describing the last error that occurred.
		///      </return>
		/// 		<short>    @brief Returns a human-readable description of the last error.</short>
		public new string ErrorString() {
			return (string) interceptor.Invoke("errorString", "errorString() const", typeof(string));
		}
		/// <remarks>
		///  @brief Open the save file.
		///  This function will open the save file by creating a temporary file to write
		///  to. It will also check to ensure that there are sufficient permissions to
		///  write to the target file.
		/// </remarks>		<return> true if successful, or false if an error has occurred.
		///      </return>
		/// 		<short>    @brief Open the save file.</short>
		public bool Open() {
			return (bool) interceptor.Invoke("open", "open()", typeof(bool));
		}
		/// <remarks>
		///  @brief Discard changes without affecting the target file.
		///  This will discard all changes that have been made to this file.
		///  The target file will not be altered in any way.
		/// </remarks>		<short>    @brief Discard changes without affecting the target file.</short>
		public void Abort() {
			interceptor.Invoke("abort", "abort()", typeof(void));
		}
		~KSaveFile() {
			interceptor.Invoke("~KSaveFile", "~KSaveFile()", typeof(void));
		}
		public new void Dispose() {
			interceptor.Invoke("~KSaveFile", "~KSaveFile()", typeof(void));
		}
		/// <remarks>
		///  @brief Static method to create a backup file before saving.
		///  If empty (the default), the backup will be in the same directory as <code>filename.</code>
		///  The backup type (simple, rcs, or numbered), extension string, and maximum
		///  number of backup files are read from the user's global configuration.
		///  Use simpleBackupFile() or numberedBackupFile() to force one of these
		///  specific backup styles.
		///  You can use this method even if you don't use KSaveFile.
		/// <param> name="filename" the file to backup
		/// </param><param> name="backupDir" optional directory where to save the backup file in.
		/// </param></remarks>		<return> true if successful, or false if an error has occurred.
		///      </return>
		/// 		<short>    @brief Static method to create a backup file before saving.</short>
		public static bool BackupFile(string filename, string backupDir) {
			return (bool) staticInterceptor.Invoke("backupFile$$", "backupFile(const QString&, const QString&)", typeof(bool), typeof(string), filename, typeof(string), backupDir);
		}
		public static bool BackupFile(string filename) {
			return (bool) staticInterceptor.Invoke("backupFile$", "backupFile(const QString&)", typeof(bool), typeof(string), filename);
		}
		/// <remarks>
		///  @brief Static method to create a backup file for a given filename.
		///  This function creates a backup file from the given filename.
		///  You can use this method even if you don't use KSaveFile.
		/// <param> name="filename" the file to backup
		/// </param><param> name="backupDir" optional directory where to save the backup file in.
		///  If empty (the default), the backup will be in the same directory as <code>filename.</code>
		/// </param><param> name="backupExtension" the extension to append to <code>filename</code>, "~" by default.
		/// </param></remarks>		<return> true if successful, or false if an error has occurred.
		///      </return>
		/// 		<short>    @brief Static method to create a backup file for a given filename.</short>
		public static bool SimpleBackupFile(string filename, string backupDir, string backupExtension) {
			return (bool) staticInterceptor.Invoke("simpleBackupFile$$$", "simpleBackupFile(const QString&, const QString&, const QString&)", typeof(bool), typeof(string), filename, typeof(string), backupDir, typeof(string), backupExtension);
		}
		public static bool SimpleBackupFile(string filename, string backupDir) {
			return (bool) staticInterceptor.Invoke("simpleBackupFile$$", "simpleBackupFile(const QString&, const QString&)", typeof(bool), typeof(string), filename, typeof(string), backupDir);
		}
		public static bool SimpleBackupFile(string filename) {
			return (bool) staticInterceptor.Invoke("simpleBackupFile$", "simpleBackupFile(const QString&)", typeof(bool), typeof(string), filename);
		}
		/// <remarks>
		///  @brief Static method to create a backup file for a given filename.
		///  This function creates a series of numbered backup files from the
		///  given filename.
		///  The backup file names will be of the form:
		///      \<name\>.\<number\>\<extension\>
		///  for instance
		///      <pre> chat.3.log </pre>
		///  The new backup file will be have the backup number 1.
		///  Each existing backup file will have its number incremented by 1.
		///  Any backup files with numbers greater than the maximum number
		///  permitted (<code>maxBackups</code>) will be removed.
		///  You can use this method even if you don't use KSaveFile.
		/// <param> name="filename" the file to backup
		/// </param><param> name="backupDir" optional directory where to save the backup file in.
		///  If empty (the default), the backup will be in the same directory as
		///  <code>filename.</code>
		/// </param><param> name="backupExtension" the extension to append to <code>filename</code>,
		///  which is "~" by default.  Do not use an extension containing digits.
		/// </param><param> name="maxBackups" the maximum number of backup files permitted.
		///  For best performance a small number (10) is recommended.
		/// </param></remarks>		<return> true if successful, or false if an error has occurred.
		///      </return>
		/// 		<short>    @brief Static method to create a backup file for a given filename.</short>
		public static bool NumberedBackupFile(string filename, string backupDir, string backupExtension, uint maxBackups) {
			return (bool) staticInterceptor.Invoke("numberedBackupFile$$$$", "numberedBackupFile(const QString&, const QString&, const QString&, const uint)", typeof(bool), typeof(string), filename, typeof(string), backupDir, typeof(string), backupExtension, typeof(uint), maxBackups);
		}
		public static bool NumberedBackupFile(string filename, string backupDir, string backupExtension) {
			return (bool) staticInterceptor.Invoke("numberedBackupFile$$$", "numberedBackupFile(const QString&, const QString&, const QString&)", typeof(bool), typeof(string), filename, typeof(string), backupDir, typeof(string), backupExtension);
		}
		public static bool NumberedBackupFile(string filename, string backupDir) {
			return (bool) staticInterceptor.Invoke("numberedBackupFile$$", "numberedBackupFile(const QString&, const QString&)", typeof(bool), typeof(string), filename, typeof(string), backupDir);
		}
		public static bool NumberedBackupFile(string filename) {
			return (bool) staticInterceptor.Invoke("numberedBackupFile$", "numberedBackupFile(const QString&)", typeof(bool), typeof(string), filename);
		}
		/// <remarks>
		///  @brief Static method to create an rcs backup file for a given filename.
		///  This function creates a rcs-formatted backup file from the
		///  given filename.
		///  The backup file names will be of the form:
		///      \<name\>,v
		///  for instance
		///      <pre> photo.jpg,v </pre>
		///  The new backup file will be in RCS format.
		///  Each existing backup file will be committed as a new revision.
		///  You can use this method even if you don't use KSaveFile.
		/// <param> name="filename" the file to backup
		/// </param><param> name="backupDir" optional directory where to save the backup file in.
		///  If empty (the default), the backup will be in the same directory as
		///  <code>filename.</code>
		/// </param><param> name="backupMessage" is the RCS commit message for this revision.
		/// </param></remarks>		<return> true if successful, or false if an error has occurred.
		///      </return>
		/// 		<short>    @brief Static method to create an rcs backup file for a given filename.</short>
		public static bool RcsBackupFile(string filename, string backupDir, string backupMessage) {
			return (bool) staticInterceptor.Invoke("rcsBackupFile$$$", "rcsBackupFile(const QString&, const QString&, const QString&)", typeof(bool), typeof(string), filename, typeof(string), backupDir, typeof(string), backupMessage);
		}
		public static bool RcsBackupFile(string filename, string backupDir) {
			return (bool) staticInterceptor.Invoke("rcsBackupFile$$", "rcsBackupFile(const QString&, const QString&)", typeof(bool), typeof(string), filename, typeof(string), backupDir);
		}
		public static bool RcsBackupFile(string filename) {
			return (bool) staticInterceptor.Invoke("rcsBackupFile$", "rcsBackupFile(const QString&)", typeof(bool), typeof(string), filename);
		}
		protected new IKSaveFileSignals Emit {
			get { return (IKSaveFileSignals) Q_EMIT; }
		}
	}

	public interface IKSaveFileSignals : IQFileSignals {
	}
}
