//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;
	using System.Runtime.InteropServices;
	using System.Text;
	using System.Collections.Generic;

	/// <remarks>
	///  Abstract base class for the worker classes behind the KMacroExpander namespace
	///  and the KCharMacroExpander and KWordMacroExpander classes.
	/// </remarks>		<author> Oswald Buddenhagen <ossi@kde.org>
	///  </author>
	/// 		<short>    Abstract base class for the worker classes behind the KMacroExpander namespace  and the KCharMacroExpander and KWordMacroExpander classes.</short>

	[SmokeClass("KMacroExpanderBase")]
	public class KMacroExpanderBase : Object, IDisposable {
		protected SmokeInvocation interceptor = null;
		private IntPtr smokeObject;
		protected KMacroExpanderBase(Type dummy) {}
		protected void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KMacroExpanderBase), this);
		}
		/// <remarks>
		///  Constructor.
		/// <param> name="c" escape char indicating start of macros, or char.Null for none
		///      </param></remarks>		<short>    Constructor.</short>
		public KMacroExpanderBase(char c) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KMacroExpanderBase#", "KMacroExpanderBase(QChar)", typeof(void), typeof(char), c);
		}
		public KMacroExpanderBase() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KMacroExpanderBase", "KMacroExpanderBase()", typeof(void));
		}
		/// <remarks>
		///  Perform safe macro expansion (substitution) on a string.
		/// <param> name="str" the string in which macros are expanded in-place
		///      </param></remarks>		<short>    Perform safe macro expansion (substitution) on a string.</short>
		public void ExpandMacros(StringBuilder str) {
			interceptor.Invoke("expandMacros$", "expandMacros(QString&)", typeof(void), typeof(StringBuilder), str);
		}
		public bool ExpandMacrosShellQuote(StringBuilder str, ref int pos) {
			StackItem[] stack = new StackItem[3];
#if DEBUG
			stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(str);
#else
			stack[1].s_class = (IntPtr) GCHandle.Alloc(str);
#endif
			stack[2].s_int = pos;
			interceptor.Invoke("expandMacrosShellQuote$$", "expandMacrosShellQuote(QString&, int&)", stack);
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
			((GCHandle) stack[1].s_class).Free();
#endif
			pos = stack[2].s_int;
			return stack[0].s_bool;
		}
		/// <remarks>
		///  Same as above, but always starts at position 0, and unmatched closing
		///  parens and braces are treated as errors.
		///      </remarks>		<short>    Same as above, but always starts at position 0, and unmatched closing  parens and braces are treated as errors.</short>
		public bool ExpandMacrosShellQuote(StringBuilder str) {
			return (bool) interceptor.Invoke("expandMacrosShellQuote$", "expandMacrosShellQuote(QString&)", typeof(bool), typeof(StringBuilder), str);
		}
		/// <remarks>
		///  Set the macro escape character.
		/// <param> name="c" escape char indicating start of macros, or char.Null if none
		///      </param></remarks>		<short>    Set the macro escape character.</short>
		public void SetEscapeChar(char c) {
			interceptor.Invoke("setEscapeChar#", "setEscapeChar(QChar)", typeof(void), typeof(char), c);
		}
		/// <remarks>
		///  Obtain the macro escape character.
		/// </remarks>		<return> escape char indicating start of macros, or char.Null if none
		///      </return>
		/// 		<short>    Obtain the macro escape character.</short>
		public char EscapeChar() {
			return (char) interceptor.Invoke("escapeChar", "escapeChar() const", typeof(char));
		}
		/// <remarks>
		///  This function is called for every single char within the string if
		///  the escape char is char.Null. It should determine whether the
		///  string starting at <code>pos</code> within <code>str</code> is a valid macro and return
		///  the substitution value for it if so.
		/// <param> name="str" the input string
		/// </param><param> name="pos" the offset within <code>str</code>
		/// </param><param> name="ret" return value: the string to substitute for the macro
		/// </param></remarks>		<return> if greater than zero, the number of chars at <code>pos</code> in <code>str</code>
		///   to substitute with <code>ret</code> (i.e., a valid macro was found). if less
		///   than zero, subtract this value from <code>pos</code> (to skip a macro, i.e.,
		///   substitute it with itself). zero requests no special action.
		///      </return>
		/// 		<short>    This function is called for every single char within the string if  the escape char is char.Null.</short>
		[SmokeMethod("expandPlainMacro(const QString&, int, QStringList&)")]
		protected virtual int ExpandPlainMacro(string str, int pos, List<string> ret) {
			return (int) interceptor.Invoke("expandPlainMacro$$?", "expandPlainMacro(const QString&, int, QStringList&)", typeof(int), typeof(string), str, typeof(int), pos, typeof(List<string>), ret);
		}
		/// <remarks>
		///  This function is called every time the escape char is found if it is
		///  not char.Null. It should determine whether the
		///  string starting at <code>pos</code> witin <code>str</code> is a valid macro and return
		///  the substitution value for it if so.
		/// <param> name="str" the input string
		/// </param><param> name="pos" the offset within <code>str.</code> Note that this is the position of
		///   the occurrence of the escape char
		/// </param><param> name="ret" return value: the string to substitute for the macro
		/// </param></remarks>		<return> if greater than zero, the number of chars at <code>pos</code> in <code>str</code>
		///   to substitute with <code>ret</code> (i.e., a valid macro was found). if less
		///   than zero, subtract this value from <code>pos</code> (to skip a macro, i.e.,
		///   substitute it with itself). zero requests no special action.
		///      </return>
		/// 		<short>    This function is called every time the escape char is found if it is  not char.Null.</short>
		[SmokeMethod("expandEscapedMacro(const QString&, int, QStringList&)")]
		protected virtual int ExpandEscapedMacro(string str, int pos, List<string> ret) {
			return (int) interceptor.Invoke("expandEscapedMacro$$?", "expandEscapedMacro(const QString&, int, QStringList&)", typeof(int), typeof(string), str, typeof(int), pos, typeof(List<string>), ret);
		}
		~KMacroExpanderBase() {
			interceptor.Invoke("~KMacroExpanderBase", "~KMacroExpanderBase()", typeof(void));
		}
		public void Dispose() {
			interceptor.Invoke("~KMacroExpanderBase", "~KMacroExpanderBase()", typeof(void));
		}
	}
}
