/*****************************************************************

Copyright (c) 2001 Matthias Elter <elter@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __fifteenapplet_h__
#define __fifteenapplet_h__

#include "qttableview.h"

#include <QtCore/QVector>
#include <QtGui/QMouseEvent>
#include <QtGui/QResizeEvent>

#include <k3panelapplet.h>

class QMenu;
class KAboutData;

class PiecesTable : public QtTableView
{
    Q_OBJECT

public:
    explicit PiecesTable(QWidget* parent = 0);
    QMenu* popup() { return _menu; }

protected:
    void resizeEvent(QResizeEvent*);
    void mousePressEvent(QMouseEvent*);
    void mouseMoveEvent(QMouseEvent*);

    void paintCell(QPainter *, int row, int col);

    void initMap();
    void initColors();
    void checkwin();

protected slots:
    void randomizeMap();
    void resetMap();

private:
    QVector<int>    _map;
    QVector<QColor> _colors;
    QMenu    *_menu;
    int _activeRow, _activeCol;
    bool            _randomized;
};

class FifteenApplet : public K3PanelApplet
{
    Q_OBJECT

public:
    explicit FifteenApplet(const QString& configFile, K3PanelApplet::Type t = K3PanelApplet::Stretch, int actions = 0,
                  QWidget *parent = 0, const char *name = 0);

    int widthForHeight(int height) const;
    int heightForWidth(int width) const;

    void about();

private:
    PiecesTable *_table;
    KAboutData   *_aboutData;
};

#endif
