
#include "bugjob.h"

#include "kbbprefs.h"

#include <kio/job.h>

#include <string.h>
#include <klocale.h>
#include <kdebug.h>

BugJob::BugJob( BugServer *server )
    : Job( ), mServer( server )
{
}

BugJob::~BugJob()
{
}

void BugJob::start( const KUrl &url )
{
    kDebug() << "BugJob::start(): " << url.url();

    if ( KBBPrefs::instance()->mDebugMode ) {
        BugSystem::saveQuery( url );
    }

    // ### obey post, if necessary

    KIO::Job *job = KIO::get( url, true /*always 'reload=true', we have our own cache*/, false );

    connect( job, SIGNAL( result( KJob * ) ),
             this, SLOT( ioResult( KJob * ) ) );
    connect( job, SIGNAL( data( KIO::Job *, const QByteArray & ) ),
             this, SLOT( ioData( KIO::Job *, const QByteArray & ) ) );
    connect( job, SIGNAL( infoMessage( KJob *, const QString &, const QString & ) ),
             this, SLOT( ioInfoMessage( KJob *, const QString &,const QString & ) ) );
    connect( job, SIGNAL( percent( KJob *, unsigned long ) ),
             this, SLOT( ioInfoPercent( KJob *, unsigned long ) ) );
}

void BugJob::ioResult( KJob *job )
{
    if ( job->error() )
    {
        emit error( job->errorText() );
        BugSystem::self()->unregisterJob(this);
        this->kill();
        return;
    }

    infoMessage( i18n( "Parsing..." ) );

#if 0
    kDebug() << "--START:" << m_data << ":END--";
#endif

    if ( KBBPrefs::instance()->mDebugMode ) {
        BugSystem::saveResponse( m_data );
    }

    process( m_data );
    infoMessage( i18n( "Ready." ) );

    emit jobEnded( this );

    delete this;
}

void BugJob::ioData( KIO::Job *, const QByteArray &data )
{
    unsigned int start = m_data.size();

    m_data.resize( m_data.size() + data.size() );
    memcpy( m_data.data() + start, data.data(), data.size() );
}

void BugJob::ioInfoMessage( KJob *, const QString &_text, const QString & )
{
    QString text = _text;
    emit infoMessage( text );
}

void BugJob::ioInfoPercent( KJob *, unsigned long percent )
{
    emit infoPercent( percent );
}

#include "bugjob.moc"

/*
 * vim:sw=4:ts=4:et
 */
