
#include <klocale.h>
#include <kcomponentdata.h>
#include <kaboutdata.h>
#include <kdebug.h>

#include "dbse_factory.h"
#include "KDBSearchEngine.h"


extern "C"
{
	KDE_EXPORT void *init_kbabeldict_dbsearchengine()
	{
		return new DbSeFactory;
	}
}


KComponentData *DbSeFactory::s_instance = 0;
KAboutData *DbSeFactory::s_about = 0;


DbSeFactory::DbSeFactory( QObject *parent )
		: KLibFactory(parent)
{
}

DbSeFactory::~DbSeFactory()
{
	if(s_instance)
	{
		delete s_instance;
		s_instance=0;
	}

	if(s_about)
	{
		delete s_about;
		s_about=0;
	}
}


QObject *DbSeFactory::createObject( QObject *parent,
				    const char *classname, const QStringList &)
{
	if(QByteArray(classname) != "SearchEngine")
	{
		kError() << "not a SearchEngine requested" << endl;
		return 0;
	}
	
	KDBSearchEngine *se = new KDBSearchEngine(parent);

	emit objectCreated(se);
	return se;
}


KComponentData DbSeFactory::componentData()
{
	if(!s_instance)
	{

		s_about = new KAboutData( "kdbsearchengine", 0,
			      ki18n("Translation Database")
				, "0.3"	,
ki18n("A fast translation search engine based on databases")
						, KAboutData::License_GPL
						, ki18n("Copyright 2000-2001 by Andrea Rizzi")
						,KLocalizedString(),0, "rizzi@kde.org");

		s_about->addAuthor(ki18n("Andrea Rizzi"),KLocalizedString(),"rizzi@kde.org");

		s_instance = new KComponentData(s_about);
	}

	return *s_instance;
}

#include "dbse_factory.moc"
