/*  -*- c++ -*-
    This file is part of KMail, the KDE mail client.
    Copyright (c) 2001-2002 Michael Haeckel <haeckel@kde.org>
    Copyright (c) 2003 Marc Mutz <mutz@kde.org>

    KMail is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License, version 2, as
    published by the Free Software Foundation.

    KMail is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

    In addition, as a special exception, the copyright holders give
    permission to link the code of this program with any edition of
    the Qt library by Trolltech AS, Norway (or with modified versions
    of Qt that use the same license as Qt), and distribute linked
    combinations including the two.  You must obey the GNU General
    Public License in all respects for all of the code used other than
    Qt.  If you modify this file, you may extend this exception to
    your version of the file, but you are not obligated to do so.  If
    you do not wish to do so, delete this exception statement from
    your version.
*/

#ifndef KPIM_SERVERTEST_H
#define KPIM_SERVERTEST_H

#include <kdepim_export.h>

#include <QObject>
#include <QString>
#include <QStringList>

namespace KIO {
  class Job;
  class Slave;
  class SimpleJob;
  class MetaData;
}
class KJob;

namespace KPIM {

/**
  Auto-detection of encryption and authentication capabilities.
*/
class KDEPIM_EXPORT ServerTest : public QObject
{
  Q_OBJECT

public:
  ServerTest( const QString & protocol, const QString & host, int port );
  virtual ~ServerTest();

Q_SIGNALS:
  void capabilities( const QStringList & capaNormal,
                     const QStringList & capaSSL );
  void capabilities( const QStringList & capaNormal,
                     const QStringList & capaSSL,
                     const QString & authNone, const QString & authSSL,
                     const QString & authTLS );

protected Q_SLOTS:
  void slotData(KJob *job, const QString &data, const QString &);
  void slotResult(KJob *job);
  void slotMetaData( const KIO::MetaData & );
  void slotSlaveResult(KIO::Slave *aSlave, int error,
    const QString &errorText = QString());

protected:
  KIO::MetaData slaveConfig() const;
  void startOffSlave( int port=0 );

protected:
  const QString  mProtocol;
  const QString  mHost;
  bool           mSSL;
  QStringList    mListNormal;
  QStringList    mListSSL;
  QString        mAuthNone;
  QString        mAuthSSL;
  QString        mAuthTLS;
  KIO::SimpleJob *mJob;
  KIO::Slave     *mSlave;
  int            mConnectionErrorCount;
};

}

#endif
