/*
    This file is part of Akregator.

    Copyright (C) 2007 Frank Osterfeld <frank.osterfeld@kdemail.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/

#ifndef AKREGATOR_SUBSCRIPTIONLISTVIEW_H
#define AKREGATOR_SUBSCRIPTIONLISTVIEW_H

#include <QTreeView>

namespace Akregator {

class TreeNode;

class SubscriptionListView : public QTreeView {
Q_OBJECT
public:
    explicit SubscriptionListView( QWidget* parent = 0 );

// the following is all transitional, for easier porting from the item-based views

    Akregator::TreeNode* findNodeByTitle( const QString& title ) const;

    void startNodeRenaming( Akregator::TreeNode* node );

    void ensureNodeVisible( Akregator::TreeNode* node );

    //override
    void setModel( QAbstractItemModel* model );

    void triggerUpdate() {}

public Q_SLOTS:

    void slotPrevFeed();
    void slotNextFeed();

    void slotPrevUnreadFeed();
    void slotNextUnreadFeed();
};

}

#endif // AKREGATOR_SUBSCRIPTIONLISTVIEW_H
