/*
    This file is part of KNewStuff2.
    Copyright (c) 2006, 2007 Josef Spillner <spillner@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef KNEWSTUFF2_UI_QASYNCPIXMAP_H
#define KNEWSTUFF2_UI_QASYNCPIXMAP_H

#include <QtGui/QPixmap>
#include <QtCore/QObject>

class KJob;

/**
 * Convenience class for images with remote sources.
 *
 * This class represents a fire-and-forget approach of loading images
 * in applications. The image will load itself.
 * Using this class also requires using QAsyncFrame or similar UI
 * elements which allow for asynchronous image loading.
 *
 * This class is used internally by the DownloadDialog class.
 *
 * @internal
 */
class QAsyncPixmap : public QObject, public QPixmap
{
    Q_OBJECT
    public:
        QAsyncPixmap(const QString& url, QObject* parent);

    Q_SIGNALS:
        void signalLoaded(const QPixmap& pix);

    private Q_SLOTS:
        void slotDownload(KJob *job);

    private:
        QString m_dest;
};

#endif

