/***************************************************************************

                             kvttabledelegate

    -----------------------------------------------------------------------

    copyright     : (C) 2006, 2007 Peter Hedlund <peter.hedlund@kdemail.net>

    -----------------------------------------------------------------------

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KVTTABLEDELEGATE_H
#define KVTTABLEDELEGATE_H

#include <QItemDelegate>
#include <QModelIndex>

/**
  @author Peter Hedlund <peter.hedlund@kdemail.net>
*/
class KVTTableDelegate : public QItemDelegate
{
    Q_OBJECT
public:
    KVTTableDelegate(QObject *parent = 0);

    QWidget * createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const;

    void setEditorData(QWidget *editor, const QModelIndex &index) const;
    void setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const;
    void setCurrentIndex(const QModelIndex &index);

    void updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index) const;
    QSize sizeHint(const QStyleOptionViewItem & option, const QModelIndex & index) const;
    void paint(QPainter * painter, const QStyleOptionViewItem & option, const QModelIndex & index) const;
protected:
    void drawDisplay(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const QString &text) const;
    void drawFocus(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect) const;

private slots:
    void commitAndCloseEditor();

private:
    QModelIndex m_currentIndex;
};

#endif
