/***************************************************************************
                         kpercentage.cpp  -  description
                            -------------------
   begin                : Fre Nov 16 14:52:33 CET 2001
   copyright            : (C) 2001 by Matthias Messmer <bmlmessmer@web.de> &
                                     Carsten Niehaus <cniehaus@gmx.de> &
                                     Robert Gogolok <mail@robert-gogolok.de>

***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kpercentage.h"

// Qt includes
#include <QApplication>
#include <QLabel>
#include <QPixmap>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QGridLayout>
#include <QMenu>
#include <QCloseEvent>

// KDE includes
#include <KComponentData>
#include <KHelpMenu>
#include <KIcon>
#include <KLocale>
#include <KMenu>
#include <KMessageBox>
#include <KPushButton>
#include <KStandardDirs>
#include <KToolInvocation>

//local includes
#include "ksplashscreen.h"

KPercentage::KPercentage( const char *name ) : KDialog ( 0 )
{
    setObjectName( QLatin1String( name ) );
    setCaption( "KPercentage" );
    setButtons( 0 );

    // show splash screen
    KSplashScreen * splash_screen = new KSplashScreen( this );
    splash_screen->show();
    splash_screen->raise();

    // let's set a suitable, not too small font size
    QFont the_font( font() );
    the_font.setPointSize( 14 );
    //the_font.setBold(true);
    setFont( the_font );

    // prepare exercise window, that will use the fontsize above!
    percent_main = new KPercentMain( this, "KPercentage" );

    // fixed geometry bacause of background pixmap
    setFixedSize( QSize( 548, 248 ) );

    /** load and set background pixmap */
    QPixmap bgp( KStandardDirs::locate( "data", QApplication::isRightToLeft() ? "kpercentage/pics/kpercentage_bg_rtl.png" : "kpercentage/pics/kpercentage_bg.png" ) );
    QPalette palette;
    palette.setBrush( backgroundRole(), QBrush(bgp) );
    setPalette( palette );

    QLabel *label_number = new QLabel( i18n( "Number of tasks:" ), this );
    QLabel *label_level = new QLabel( i18n( "Level:" ), this );
    QLabel *label_choose = new QLabel( i18n( "Choose an exercise type:" ), this );

    /** make labels transparent */
    label_number->setPalette( palette );
    label_level->setPalette( palette );
    label_choose->setPalette( palette );

    // xgettext: no-c-format
    KPushButton *button_basevalue = new KPushButton( i18n( "x% &of ?? = y" ), this );
    // xgettext: no-c-format
    KPushButton *button_percentvalue = new KPushButton( i18n( "x% of &y = ??" ), this );
    // xgettext: no-c-format
    KPushButton *button_percentage = new KPushButton( i18n( "??% o&f x = y" ), this );
    KPushButton *button_random = new KPushButton( i18n( "??" ), this );
    KPushButton *button_help = new KPushButton( KStandardGuiItem::help().text(), this );
    button_help->setIcon( KIcon("help-contents") );
    KHelpMenu *help_menu = new KHelpMenu( this, KGlobal::mainComponent().aboutData(), true );
    button_help->setMenu( help_menu->menu() );
    KPushButton *button_close = new KPushButton( i18n( "E&xit" ), this );
    button_close->setIcon( KIcon("application-exit") );

    combo_box_level = new KComboBox( this );
    combo_box_level->addItem( i18n( "Easy" ) );
    combo_box_level->addItem( i18n( "Medium" ) );
    combo_box_level->addItem( i18n( "Crazy" ) );

    spin_box_number = new QSpinBox( this );
    spin_box_number->setMinimum( 1 );
    spin_box_number->setMaximum( 10 );
    spin_box_number->setSingleStep( 1 );
    spin_box_number->setValue( 5 );

    // connecting all the slots
    connect( button_basevalue, SIGNAL( clicked() ), this, SLOT( selBasevalue() ) );
    connect( button_percentvalue, SIGNAL( clicked() ), this, SLOT( selPercentvalue() ) );
    connect( button_percentage, SIGNAL( clicked() ), this, SLOT( selPercentage() ) );
    connect( button_random, SIGNAL( clicked() ), this, SLOT( selRandom() ) );
    connect( button_help, SIGNAL( clicked() ), this, SLOT( needHelp() ) );
    connect( button_close, SIGNAL( clicked() ), this, SLOT( accept() ) );

    ////////
    // begin layouting
    ////////
    delete layout();
    QVBoxLayout *main_layout = new QVBoxLayout( this );
    main_layout->setSpacing( 20 );
    main_layout->setMargin( 20 );
    main_layout->setObjectName( "main_layout" );
    main_layout->setSizeConstraint( QLayout::SetNoConstraint );

    QHBoxLayout *top_layout = new QHBoxLayout(  );
    top_layout->setSpacing( 20 );
    top_layout->setObjectName( "top_layout" );
    top_layout->addWidget( label_number );
    top_layout->addWidget( spin_box_number );
    top_layout->addSpacing( 20 );
    top_layout->addStretch();
    top_layout->addWidget( label_level );
    top_layout->addWidget( combo_box_level );

    main_layout->addItem(top_layout);
    main_layout->addSpacing( 40 );
    main_layout->addStretch();

    QHBoxLayout *bottom_layout = new QHBoxLayout(  );
    main_layout->addItem( bottom_layout );
    bottom_layout->setObjectName( "bottom_layout" );
    QVBoxLayout *bLeftLayout = new QVBoxLayout(  );
    bottom_layout->addItem( bLeftLayout );
    bLeftLayout->addWidget( label_choose );
    bLeftLayout->addSpacing( 10 );

    QGridLayout *grid_layout = new QGridLayout();
    bLeftLayout->addItem( grid_layout );
    grid_layout->setMargin( 0 );
    grid_layout->setSpacing( 10 );
    grid_layout->addWidget( button_basevalue, 0, 0 );
    grid_layout->addWidget( button_percentvalue, 1, 0 );
    grid_layout->addWidget( button_percentage, 0, 1 );
    grid_layout->addWidget( button_random, 1, 1 );

    bottom_layout->addStretch();

    QVBoxLayout *b_right_layout = new QVBoxLayout(  );
    bottom_layout->addItem( b_right_layout );
    b_right_layout->addStretch();
    b_right_layout->addWidget( button_help );
    b_right_layout->addSpacing( 10 );
    b_right_layout->addWidget( button_close );

    main_layout->addStretch();
    ////////
    // end layouting
    ////////

    ////////
    // Tooltips
    button_basevalue->setToolTip( i18n( "Exercises with base value omitted" ) );
    button_percentvalue->setToolTip( i18n( "Exercises with percent value omitted" ) );
    button_percentage->setToolTip( i18n( "Exercises with percentage omitted" ) );
    button_random->setToolTip( i18n( "Several exercise types in random" ) );
    spin_box_number->setToolTip( i18n( "Choose the number of exercises from 1 to 10." ) );
    combo_box_level->setToolTip( i18n( "Choose the level of difficulty." ) );
    button_close->setToolTip( i18n( "Close KPercentage." ) );
    button_help->setToolTip( i18n( "Get some help." ) );

    ////////
    // WhatsThis
    button_basevalue->setWhatsThis( i18n( "Click here to start a sequence of exercises where the base value is omitted.") );
    button_percentvalue->setWhatsThis( i18n( "Click here to start a sequence of exercises where the percent value is omitted." ) );
    button_percentage->setWhatsThis( i18n( "Click here to start a sequence of exercises where the percentage is omitted." ) );
    button_random->setWhatsThis( i18n( "Click here to start a sequence of exercises where one value is omitted at random." ) );
    spin_box_number->setWhatsThis( i18n( "Here you can adjust the number of exercises from 1 to 10." ) );
    combo_box_level->setWhatsThis( i18n( "Choose one of the levels <i>easy</i>, <i>medium</i>, and <i>crazy</i>." ) );
    button_close->setWhatsThis( i18n( "Close KPercentage." ) );
    button_help->setWhatsThis( i18n( "Get some help." ) );
}

void KPercentage::selPercentage()
{
    // set the proper value for KPercentMain::selected_type
    percent_main->selected_type = SEL_PERCENTAGE;
    // and lets go!
    startExercise();
}

void KPercentage::selBasevalue()
{
    // set the proper value for KPercentMain::selected_type
    percent_main->selected_type = SEL_BASEVALUE;
    // and lets go!
    startExercise();
}

void KPercentage::selPercentvalue()
{
    // set the proper value for KPercentMain::selected_type
    percent_main->selected_type = SEL_PERCENTVALUE;
    // and lets go!
    startExercise();
}

void KPercentage::selRandom()
{
    // set the proper value for KPercentMain::selected_type
    percent_main->selected_type = SEL_RANDOM;
    // and lets go!
    startExercise();
}

/** No descriptions */
void KPercentage::startExercise()
{
    // copy the actual settings to the KPercentMain instance
    percent_main->setNumber( spin_box_number->value() );
    percent_main->selected_level = combo_box_level->currentIndex();
    percent_main->initExercise();
    hide();
    percent_main->exec();
    show();
}

void KPercentage::needHelp()
{
    KToolInvocation::invokeHelp( "", QLatin1String( "kpercentage" ) );
}

void KPercentage::closeEvent( QCloseEvent * )
{
    exit( 0 );
}

#include "kpercentage.moc"
