/**
 * Copyright (c) 2001 Dawit Alemayehu <adawit@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef __UAPROVIDERDLG_H___
#define __UAPROVIDERDLG_H___


#include <kdialog.h>
#include <klineedit.h>
#include "ui_uagentproviderdlg_ui.h"

class FakeUASProvider;

class UAProviderDlgUI : public QWidget, public Ui::UAProviderDlgUI
{
public:
  UAProviderDlgUI( QWidget *parent ) : QWidget( parent ) {
    setupUi( this );
  }
};


class UALineEdit : public KLineEdit
{
  Q_OBJECT

public:
  UALineEdit( QWidget *parent );

protected:
  virtual void keyPressEvent( QKeyEvent * );
};

class UAProviderDlg : public KDialog
{
  Q_OBJECT

public:
  UAProviderDlg( const QString& caption, QWidget *parent = 0,
                 FakeUASProvider* provider = 0 );
  ~UAProviderDlg();

  void setSiteName( const QString& );
  void setIdentity( const QString& );

  QString siteName();
  QString identity();
  QString alias();

protected Q_SLOTS:
  void slotActivated( const QString& );
  void slotTextChanged( const QString& );

protected:
  void init();

private:
  FakeUASProvider* m_provider;
  UAProviderDlgUI* dlg;
};
#endif
