#ifndef _HISTORY_MANAGER_H
#define _HISTORY_MANAGER_H

#include <kurl.h>
#include <qvaluestack.h>
#include <qobject.h>

class HistoryManager : public QObject {
  Q_OBJECT
  public:
    HistoryManager(QObject *parent = NULL);
    ~HistoryManager();
    KUrl back();
    KUrl forward();
    void addURL(const KUrl &);
    enum Buttons {
      Back,
      Forward
    };
  signals:
    void uiChanged(int, bool);
  protected:
    QValueStack<KUrl> back_stack;
    QValueStack<KUrl> forward_stack;
    KUrl currentURL;
};
  
#endif
