/***************************************************************************
 *   Copyright (C) 2006 by Rohan McGovern                                  *
 *   rohan.pm@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DBUSMETHODORSIGNAL_H
#define DBUSMETHODORSIGNAL_H

#include <qstring.h>
#include <qptrlist.h>

#include "dbusexceptions.h"
#include "dbusannotatable.h"

class DBusMethodArgument;

/**
 * Either a method or a signal.
 */
class DBusMethodOrSignal
 : public DBusAnnotatable
{
public:
    /**
     * @param parent parent QListViewItem
     * @param elem  QDomElement representing this method or signal as
     *              returned by
     *              org.freedesktop.DBus.Introspectable.Introspect.
     * @param type  "Method" or "Signal"
     */
    DBusMethodOrSignal(
      QListViewItem * parent,
      QDomElement const & elem,
      QString const & type
    ) throw( QDBusXmlError );

    /**
     * @returns name of this method or signal.
     */
    virtual QString name() const;

    /**
     * @returns signature of this method or signal.
     */
    virtual QString signature() const;

    virtual ~DBusMethodOrSignal();

protected:
    /**
     * Figure out the signature of this method or signal.
     */
    virtual QString discoverSignature() const;

    QString m_name;
    QString m_signature;
    QPtrList< DBusMethodArgument > m_args;

private:
    /// Not implemented.
    DBusMethodOrSignal( DBusMethodOrSignal const & other );

    /// Not implemented.
    const DBusMethodOrSignal & operator=( DBusMethodOrSignal const & other);
};

#endif
