/***************************************************************************
 *   Copyright (C) 2006 by Rohan McGovern                                  *
 *   rohan.pm@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DBUSMETHODARGUMENT_H
#define DBUSMETHODARGUMENT_H

#include <memory>
#include <qstring.h>

#include "dbusexceptions.h"

class QDomElement;

/**
 * An argument to a method or signal.
 */
class DBusMethodArgument {
public:
    /**
     * @param elem XML element representing a method or signal argument
     */
    DBusMethodArgument( QDomElement const & elem )
      throw ( QDBusXmlError );

    ~DBusMethodArgument();

    /**
     * @returns name of this argument (may be null)
     */
    QString name() const;

    /**
     * D-BUS type string.  examples:
     *   s         - string
     *   (ii)      - struct of two integers
     *   ai        - array of ints
     *   a{si}     - dict mapping string to unsigned int
     * @returns type string of this argument.  See D-BUS spec.
     */
    QString type() const;

    /**
     * @returns direction ("in" or "out").
     */
    QString direction() const;

    /**
     * @returns human-readable type string.
     */
    QString niceType() const;

private:
    class Private; Private * d;

    /// Not implemented.
    DBusMethodArgument( DBusMethodArgument const & other );

    /// Not implemented.
    const DBusMethodArgument & operator=( DBusMethodArgument const & other );
};

#endif
