/***************************************************************************
 *   Copyright (C) 2005 by Felipe Sateler                                  *
 *   fsateler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/
#include "autostartlistviewitem.h"
#include <klocale.h>

AutostartListViewItem::AutostartListViewItem(QListView* parent)
	: KListViewItem(parent)
{
}


AutostartListViewItem::~AutostartListViewItem()
{
}


QString AutostartListViewItem::getCommand() const
{
	return command;
}

QString AutostartListViewItem::getName() const
{
	return name;
}

QString AutostartListViewItem::getComment() const
{
	return comment;
}

void AutostartListViewItem::setCommand(const QString& newCommand)
{
	if( newCommand.isNull() || newCommand.isEmpty() )
	{
		command = QString::null;
		setText(1, i18n("N/A") );
	}
	else
	{
		command = newCommand;
		setText(1, command );
	}
}

void AutostartListViewItem::setName(const QString& newName)
{
	if( newName.isNull() || newName.isEmpty() )
	{
		name = QString::null;
		setText( 0, i18n("N/A") );
	}
	else
	{
		name = newName;
		setText(0, name);
	}
}

void AutostartListViewItem::setComment(const QString& newComment)
{
	if( newComment.isNull() || newComment.isEmpty() )
	{
		comment = QString::null;
		setText(2, i18n("N/A") );
	}
	else
	{
		comment = newComment;
		setText(2, comment);
	}
}
