/***************************************************************************
 *   Copyright (C) 2005 by Felipe Sateler                                  *
 *   fsateler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _AUTOSTART_H_
#define _AUTOSTART_H_

#include <kcmodule.h>

class KAboutData;
class KListView;
class KGroupBox;
class QPushButton;
class AutostartWidget;
class KDirLister;
struct AppInfo;
class QValueList<class T>;


class Autostart: public KCModule
{
	Q_OBJECT

public:
	Autostart( QWidget *parent=0, const char *name=0, const QStringList& = QStringList() );
	~Autostart();

	virtual void load();
	virtual void save();
//	virtual void defaults();
	virtual int buttons();
	virtual QString quickHelp() const;
	virtual const KAboutData *aboutData()const
		{ return myAboutData; };

public slots:
	void configChanged();
	
	void completed();
	void newItems(const KFileItemList& items);
	void removeCompleted();
	void removeItems(const KFileItemList& items);
	
	void widgetChanged();

protected:
	AppInfo parseDesktopFile(const KURL&);
	
private:
	KAboutData *myAboutData;
	AutostartWidget* widget;
	
	KDirLister *lister;
	QValueList<AppInfo> info;
};

#endif
