/***************************************************************************
                          kcmpureftpdstat.h  -  PureFTPd Statistics
                             -------------------
    begin                : Thu Jan 2 2002
    copyright            : (C) 2002,2003 by Claudiu Costin
    email                : claudiuc@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __KCMPUREFTPDSTAT_H__
#define __KCMPUREFTPDSTAT_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <signal.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <qglobal.h>
#include <qmap.h>
#include <qstring.h>
#include <qtimer.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qcombobox.h>
#include <qtextview.h>
#include <qtabwidget.h>
#include <qmultilineedit.h>

#include <kdeversion.h>
#include <kdebug.h>
#include <kglobal.h>
#include <kconfig.h>
#include <kapp.h>
#include <kcmodule.h>
#include <kaboutdata.h>
#include <kurlrequester.h>
#include <knuminput.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <klistview.h>
#include <kprocess.h>

#include "ftpsession.h"


typedef QMap<pid_t,KListViewItem*> FtpGuiMap;
typedef QMap<pid_t,FTPSessionItem> FtpSessionMap;

class KPureftpdStat : public KCModule {
    Q_OBJECT

public:
		enum InfoMessage {
			InfoClear, InfoInit, InfoWarning, InfoExecRunning,
      InfoExecCommandError, InfoExecCommandKill
		};
		enum LogMessage {
			LogClear, LogInit, LogWriteError, LogExecTailError, 
			LogExecCommandError, LogExecTerminated, LogFull
		};
		
    KPureftpdStat(QWidget *parent = 0L, const char *name = 0L);
    virtual ~KPureftpdStat();
    void load();
    void save();
    void defaults();
    int buttons();
    QString quickHelp() const;
    virtual const KAboutData *aboutData() const;

protected slots:
    void configChanged();
    void configChanged(int number);
    void configChanged(const QString &text);
    void slotShowExtendedInfo(QListViewItem *item);
    void slotChangedInterval(int interval);

    void slotLogSearch();
    void slotLogResetSearch();
    void slotLogSave();
    void slotLogCopy();
    void slotLogClear();

    void slotLogProcessToggleUpdate(bool toggled);
		void slotLogProcessRecvStdout(KProcess *p, char *buf, int len);
		void slotLogProcessRecvStderr(KProcess *p, char *buf, int len);
		void slotLogProcessExited(KProcess *p);
    void startLogProcess();
    void stopLogProcess();

    void slotInfoProcessToggleUpdate();
		void slotInfoProcessRecvStdout(KProcess *p, char *buf, int len);
		void slotInfoProcessRecvStderr(KProcess *p, char *buf, int len);
		void slotInfoProcessExited(KProcess *p);
    void startInfoProcess();
    void stopInfoProcess();

		void slotInfoConfDefault(bool b);
		void slotInfoConfUseDefault(bool b);
		void slotLogConfDefault(bool b);

private:
    void initView();
    void processInfoOutput();
		void displayInfoMessage(InfoMessage t);
		void displayLogMessage(LogMessage t);
    QString prettyByte(unsigned long long m_byte);

    bool mFound, reachedMaxNumLines, deliberatedKill, isProcessingInfo;
		int logMaxNumLines;
    FtpGuiMap ftpGuiMap;
    FtpSessionMap ftpSessionMap;
    QTimer *infoTimer;
    QString infoOutput, lastLine, pureftpwhoDefaultPath,
		        pureftpwhoExe, startDir, fileName,
            tmpStdout, tmpStderr;
		QGroupBox 	 *grpInfoMessage, *grpLogMessage;
    QTabWidget   *tab;
    QWidget      *tabInfo, *tabLog, *tabConfig;
		QLabel       *txtPureftpwhoPath, *txtInfoCommand,
								 *txtLogFileName, *txtLogCommand,
								 *mesgInfoIcon, *mesgInfoText, *mesgLogIcon, *mesgLogText;
		QRadioButton *rbLogFile, *rbLogCustom, *rbInfoDefault, *rbInfoCustom;
		QCheckBox    *caseSensitive, *wholeWords, *findBackwards,
								 *pureftpwhoDefault;
    QTextView    *txtExtInfo;
		QMultiLineEdit *logOutput;
		KLineEdit    *editSearch, *infoCommand, *logCommand;
		KURLRequester *logFileName, *pureftpwhoPath;
    KPushButton  *infoUpdate, *logUpdate, *logSearch, *logResetSearch,
								 *logSave, *logCopy, *logClear;
    KListView    *connList;
    KIntNumInput *updateInterval, *historyLines;
    KConfig      *config;
    KAboutData   *myAboutData;
    KShellProcess *infoProcess, *logProcess;
};

#endif

