/***************************************************************************
 *   Copyright (C) 2004 by Matthew Wlazlo                                  *
 *   mwlazlo@gmail.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef GMAIL_PARSER_H
#define GMAIL_PARSER_H

#include <qobject.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qmap.h>
#include <qvaluevector.h>
#include <vector>

/**
@author Matthew Wlazlo
*/
class GMailParser : public QObject
{
	Q_OBJECT
public:
	// "qu"
	typedef struct {
		QString used;
		QString total;
		QString percent;
		QString colour;
	} Quota;

	// "ds"
	typedef struct {
		unsigned int inbox;
// 		unsigned int starred;
		unsigned int drafts;
// 		unsigned int sent;
// 		unsigned int all;
		unsigned int spam;
// 		unsigned int trash;
	} DefaultSearchSummary;
	
	// "ct" : array
	typedef struct {
		QString name;
		unsigned int count;
	} Label;

	// "t"
	typedef struct {
		int id;
		QString replyId;
		bool isNew;
		unsigned int unknown1;
		QString date_short;
		QString senders;
		QString chevron;
		QString subject;
		QString snippet;
		QString labels;
		QString attachments;
		QString msgId;
		unsigned int unknown2;
		QString date_long;
		unsigned int unknown3;
		QString unknown4;
		unsigned int unknown5;
		bool isNull; 
	} Thread;
	
	// "v"
	typedef struct {
		QString unknown1;
		QString language;
		unsigned int unknown2;
		unsigned int unknown3;
		QString version;
	} Version;
public:
	GMailParser();
	virtual ~GMailParser();

	void parse(const QString &data);
	
	unsigned int getNewCount() const;
	unsigned int getNewCount(bool realCount) const;
	unsigned int getNewCount(bool realCount, QString box) const;

// 	const QString &getVersion() const { return mVersion; }
	unsigned int getInvites() const { return mInvites; }

	const DefaultSearchSummary &getSummary() const { return mSummary; }

	const Quota& getQuota() const { return mQuota; }
	const std::vector<Label>& getLabel() const { return mLabels; }

	// key = msgId, bool = isNew
	QMap<QString,bool> *getThreadList() const;
	const Thread &getThread(const QString &msgId) const;
	const Thread &getThread(int id) const;
	
	QString stripTags(QString data);
	QString convertEntities(QString data);
	QString cleanUpData(QString data);

signals:
	void mailArrived(unsigned int count);
	void mailCountChanged();
	void versionMismatch();
	void gNameChanged(QString name);

protected:
	void parseQuota(const QString&);
	void parseDefaultSummary(const QString&);
	void parseLabel(const QString&);
	uint parseThread(const QString&, const QMap<QString,bool>*);
	void parseVersion(const QString&);
	void parseInvite(const QString&);
	void parseGName(const QString&);
	void freeThreadList();

private:
	Version mVersion;
	unsigned int mInvites;
	unsigned int mCurMsgId;
	Quota mQuota;
	DefaultSearchSummary mSummary;
	std::vector<Label> mLabels;
	QMap<QString,Thread*> mThreads;
	QValueVector<QString> gGMailVersion;
#ifdef DETECT_GLANGUAGE
	QMap<QString, QString> gGMailLanguageCode;
#endif
	QString gName;
};
#endif
