/***************************************************************************
                          kcoverfont.cpp  -  description
                             -------------------
    begin                : Mon Apr 3 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kcoverfont.h"
#include <id.h>
#include <qfontinfo.h>

KCoverFont::KCoverFont(char * name)
{
	Font = new QFont(name);
	front = new QColor(Qt::black);
	back = new QColor(Qt::white);
}

KCoverFont::~KCoverFont()
{
	delete Font;
	delete front;
	delete back;
}

KCoverFont::KCoverFont(const KCoverFont &p)
{
	Font = new QFont(*p.Font);
	front = new QColor(*p.front);
	back = new QColor(*p.back);
}

void KCoverFont::Save(QFile &file)
{
	char tmp[256];
	int r1;
	
	// tag TAG_FONT
	tmp[0] = TAG_FONT;
	file.writeBlock( tmp, 1 );
	
	// save the font information
	QFontInfo fi(*Font);
	r1 = strlen(fi.family());
	file.writeBlock( (char *)&r1, sizeof(int) );
	file.writeBlock( fi.family(), r1 );
	r1 = fi.pointSize();
	file.writeBlock( (char *)&r1, sizeof(int) );
	r1 = fi.weight();
	file.writeBlock( (char *)&r1, sizeof(int) );
	tmp[0] = fi.italic();
	// tmp[1] = fi.charSet();
	file.writeBlock( tmp, 1 );
}

void KCoverFont::Load(QFile &file, int )
{
	int err, r1, r2;
	char tmp[256], family[256];
	
	err = file.readBlock( tmp, 1 );
	if ( tmp[0]!= TAG_FONT )
		return; // error : not a string
	err = file.readBlock( (char *)&r1, sizeof(int) );
	err = file.readBlock( family, r1 );
	family[r1] = 0;
	err = file.readBlock( (char *)&r1, sizeof(int) );
	err = file.readBlock( (char *)&r2, sizeof(int) );
	err = file.readBlock( tmp, 1 );
	Font = new QFont( family, r1, r2, tmp[0]); //, (QFont::CharSet)tmp[1] );
}
