/***************************************************************************
                          kcdlabel.h  -  description
                             -------------------
    begin                : jeu mar 23 20:03:45 CET 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCDLABEL_H
#define KCDLABEL_H

#include <kapp.h>
//#include <ktopwidget.h>
#include <kmainwindow.h>
#include <klocale.h>
#include <ktoolbar.h>

#include <qwidget.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qcolor.h>
#include <qstatusbar.h>
#include <qpainter.h>
#include <kprinter.h>
#include <qkeycode.h>
#include <qfiledialog.h>

#include <kcoverpage.h>
#include <kcoverback.h>
#include <kcoverobject.h>
#include <kcoverstring.h>
#include <kcoverimage.h>
#include <kcoverfont.h>
#include <sideeditdlg.h>
#include <about.h>
#include <stringeditdlg.h>
#include <vector>
#include <scaleimagedlg.h>
#include <id.h>
#include <kdirtree.h>
#include <sourceselectdlg.h>
#include <bodylayout.h>
#include <pagenumberdlg.h>
#include <stringcurvededit.h>
#include <kcovermultistring.h>
#include <stringmultilinedlg.h>
#include <kcoverbody.h>
#include <thanksdlg.h>
#include <kcoverroundpage.h>
#include <kprintrounddlg.h>
#include <kurl.h>
#include <backgrounddialog.h>
#include <kroundcoverbackground.h>
#include <aligndlg.h>
#include <kcoverobjectcontainer.h>
#include <cddbaccessdialog.h>

class KCDLabel : public KMainWindow //KTopLevelWidget
{
  Q_OBJECT

private: // Private attributes
  // menu items
  QPopupMenu * filemenu;
  QPopupMenu * editmenu;
  QPopupMenu * bodymenu;
  QPopupMenu * slidemenu;
  QPopupMenu * imagemenu;
  QPopupMenu * stringmenu;
  QPopupMenu * pagemenu;
  QPopupMenu * alignmenu;
  QPopupMenu * alignimagemenu;
  QPopupMenu * orderimagemenu;
  QPopupMenu * helpmenu;
  QPopupMenu * columnmenu;
  QPopupMenu * levelmenu;
  QPopupMenu * cddbmenu;

  KStatusBar * statusbar;
  KToolBar * peptoolbar;

  // popup menus (right click activates them)
  QPopupMenu * ImagePopupMenu;
  QPopupMenu * orderImagePopupMenu;
  QPopupMenu * alignImagePopupMenu;
  QPopupMenu * GlobalPopupMenu;
  QPopupMenu * StringPopupMenu;
  QPopupMenu * orderstringmenu;
  QPopupMenu * PagePopupMenu;

private slots: // Private slots
  void slotCut();
  void slotCopy();
  void slotPaste();
  /** Open a saved CD content */
  void slotFileOpen();
  /** Read the CD content */
  void slotBodyReadCD();
  /** Edit the text for the side of the CD */
  void slotSlideEditText();
  /** save the current cd content */
  void slotFileSave();
  /** go to page number */
  void slotPageNumber();
  /** go to back page */
  void slotPageBack();
  /** go to round page */
  void slotPageRound();
  /** go to the front page */
  void slotPageFront();
  /** call the print setup dialog */
  void slotFilePrintSetup();
  /** Print the cd label */
  void slotFilePrint();
  /** Print the round cd label */
  void slotFilePrintRound();
  /** create a new cd label */
  void slotFileNew();
  /** Select the side text alignement property */
  void slotAlignMenu(int id);
  /** insert an image to the current page */
  void slotImageInsert();
  /**  */
  void slotImageResizeFullPage();
  /** make the slide background transparent */
  void slotImageTransparent(int);
  /** align the image to the center of the page */
  void slotImageAlignCenter();
  /**  */
  void slotImageDecreaseOrder();
  /**  */
  void slotImageIncreaseOrder();
  /** display the about box */
  void slotHelpAbout();
  /** insert a string on a page */
  void slotStringInsert();
  /** delete selected object */
  void slotObjectDelete();
  /**  */
  void slotStringDecreaseOrder();
  /**  */
  void slotStringIncreaseOrder();
  /** modify the selected string */
  void slotStringModify();
  /** fix the number of levels to scan */
  void slotNumberLevel(int);
  /** resize image to xxx % or pixels */
  /** set the number of columns to display */
  void slotNumberColumn(int id);
  void slotImageResize();
  /** select the source dircetory to read from */
  void slotBodySelectSource();
  /** select font to use for body */
  void slotBodySelectFont();
  /** user select line or not */
  void slotBodyLined(int id);
  /** user select tree lines or not */
  void slotBodyDrawTree(int id);
  /** enable page number display */
  /** display body layout dialog */
  void slotBodyLayout();
  void slotBodyPageNumber(int id);
  /** invoke the help manual */
  void slotHelpManual();
  /** insert a line of text on a circle */
  void slotStringInsertCurved();
  /** insert a multi line of text */
  void slotStringInsertMulti();
  /** increase order of a multi line string */
  void slotStringMultiIncreaseOrder();
  /** decrease order of a multi line string */
  void slotStringMultiDecreaseOrder();
  /** set the image to be drawn tiled */
  void slotImageTiled();
  /** transparency of not */
  void slotImageTransparency();
  /** user press a tool bar button */
  void slotToolBarClick(int id);
  /** user move the toolbar */
  void slotToolBarMoved();
  /** open the greeting dialog */
  void slotHelpThanks();
  /** select a background color for the current page */
  void slotPageColor();
  /** align selected object on the page */
  void slotPageAlignObject();
  /** access to cddb server */
  void CDDBAccess();

private :

  // vector of all front pages
  std::vector<KCoverPage> FrontPages;
  // there is one and only one back page per CD Label
  KCoverBack BackPage;
  // there is one and only one round page per CD Label
  KCoverRoundPage RoundPage;
  // set to true if printing ! (so we use the same QPainter object !)
  bool Printing;
  KPrinter * Printer;
  // display current page (0=back, 1=first front page, 2=second front page ... n=n-th front page)
  int CurrentPageToDisplay;
  int Slide_Align;
  int AlignChecked;
  QString ImageFilename;
  KCoverImage * ImageSelected;
  /** used for moving objects on the current page */
  QPoint InitialPosForMove;
  /** double buffering */
  QPixmap bufferpixmap;
  /** this is a pointer of the object selected
      by the user (dbl click on it) */
  KCoverObject * ObjectSelected;

  //bool SlideTransparentBackground;

  /** left upper corner of the frame to draw */
  int TopX;
  int TopY;
  /** position where user insert by click */
  QPoint ClickedPos;
  /** body=content of a CD */
  KCoverBody *TheBody;
  /** object container used for operation like cut-copy-paste, used like a clipboard */
  KCoverObjectContainer myClipboard;

public:
  /** construtor */
  KCDLabel(const char *name=0);
  /** destructor */
  virtual ~KCDLabel();
  /** Draw the back page of the cd cover */
  void PaintBackPage(QPainter *);
  /** Draw the back page of the cd cover */
  void PaintFrontPage(QPainter *, int page);
  /** Draw the round page of the cd cover */
  void PaintRoundPage(QPainter *);
  /** display the current page in the status bar */
  void DisplayCurrentPage() const;
  /** Enable/disable some controls according to the selection */
  void EnableComponents();
  /** adjust the body menu settings */
  void AdjustBodyMenuParameters();
    /** Open a named cd-label file */
  void NamedFileOpen(KURL url);
  
  unsigned int GetNumberOfPagesToPrint(unsigned int);
  /** return true if the booklet could be saved or printed (if there are valid pages) */
  bool CoverToBeSaved();
  /** return true if the round page has to be printed */
  bool RoundPageToBePrinted();
  /** return true if the cover is valid to be printed */
  bool CoverToBePrinted();


protected :
  /** define the paint event */
  void paintEvent( QPaintEvent * event);
  /** intercept key event such as Page Down/up, Home ... */
  void keyPressEvent ( QKeyEvent * e );
  /** manage the resizing of the window */
  virtual void resizeEvent(QResizeEvent * event);
  /**  */
  void mousePressEvent( QMouseEvent * );
  /** mouse press event --> select/unselect object on the current page */
  void mouseDoubleClickEvent( QMouseEvent * );
  /** mouse move event : move current item selected */
  void mouseMoveEvent ( QMouseEvent * );
  /** user release the mouse button */
  void mouseReleaseEvent ( QMouseEvent * );
  /** display the correct status info according to selected object */
  void AdjustStatus();
};

#endif
