/***************************************************************************

   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "medialistview.h"

#include <QLayout>
#include <QPushButton>

#include <kdebug.h>

#include "medialist.h"
#include "itemsmanager.h"
#include "composereditor.h"

namespace KBlogger
{

MediaListView::MediaListView( const QString& blogname, QWidget* parent ):
        QDialog(parent), mBlogname(blogname)
{
    kDebug();
    mMediaList = new MediaListWidget(blogname, this);
    QVBoxLayout *mainLayout = new QVBoxLayout (this);
    setLayout(mainLayout);
    mainLayout->addWidget(mMediaList);

    QHBoxLayout *buttonLayout = new QHBoxLayout(this);
    mainLayout->addLayout(buttonLayout);

    insertMediaButton = new QPushButton(i18n("Insert Media"), this);
    buttonLayout->addWidget(insertMediaButton);
    buttonLayout->insertStretch(0);

    populate();

    //Connect
    connect(insertMediaButton, SIGNAL(clicked()), SLOT(insertMediaInTheEditor()));

    connect(mMediaList->listTree, SIGNAL( itemDoubleClicked ( QTreeWidgetItem * , int  )),
            SLOT( insertMediaInTheEditor() ));
    exec();
}

MediaListView::~MediaListView()
{
    kDebug();
    delete  mMediaList;
    delete  insertMediaButton;
}

void MediaListView::insertMediaInTheEditor()
{
    kDebug();
    Q_ASSERT(mMediaList);
    ComposerEditor *c = qobject_cast<ComposerEditor*> (parent());
    Q_ASSERT(c);
    KBloggerMedia* media = mMediaList->getCurrentMedia();
    KBloggerMedia* thumbnail = mMediaList->getCurrentThumbnail();
    if (thumbnail && media) {
        c->insertThumbnail(thumbnail,media);
    }
    else {
        if (!media) return; //media is 0x0 if no item is selected.
        c->insertMedia(media);
    }
    close();
}

void MediaListView::populate()
{
    kDebug();
    Q_ASSERT(mMediaList);
    const QList<KBloggerMedia*> media = ItemsManager::self()->getMediaList(mBlogname);
    for (int i = 0; i < media.size(); ++i) {
        if (media.at(i))
            mMediaList->appendMedia(media.at(i));
    }
}

} //namespace

#include "medialistview.moc"
