/***************************************************************************

   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef IMPORTMEDIADIALOG_H
#define IMPORTMEDIADIALOG_H

#include <KDialog>

#include "ui_importmediadialogbase.h"
#include "kbloggermedia.h"

class KJob;

namespace KBlogger
{

/**
 * This Dialog Import local and remote media in kblogger
 */

class ImportMediaWidget : public QWidget, public Ui::ImportMediaWidgetBase
{
    Q_OBJECT
public:
    //Costructor
    ImportMediaWidget(QWidget *parent = 0);
    //Default destructor
    virtual ~ImportMediaWidget();

    void addUrl(const QString& url, const QString& blogname, const QString& postId);

protected Q_SLOTS:
    //Button functions
    void accept();
    void close();

private Q_SLOTS:
    void handleFileJobResult( KJob* job );

private:
    KDialog* mParent;
    void createMediaFromUrl(QTreeWidgetItem*);
    QList<QTreeWidgetItem*> urls;
    QMap<KJob*,QTreeWidgetItem*> jobsMap;
    //Number of the urls skipped because they are blacklisted
    int blackListedUrls;
};

} //namespace

#endif
