/***************************************************************************
 *   Copyright (C) 2004-2005 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qfile.h>
#include <qapplication.h>
#include <qspinbox.h>

#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <kdebug.h>
#include <kio/netaccess.h>
#include <kurl.h>

#include <fileimporterbibtex.h>
#include "webqueryzmath.h"

namespace KBibTeX
{

    WebQueryZMATH::WebQueryZMATH( QWidget* parent, const char* name ): WebQuery( parent, name )
    {
        m_wizard = new WebQueryWizardZMATH( title(), parent, name );
    }

    WebQueryZMATH::~WebQueryZMATH()
    {
        delete m_wizard;
    }

    BibTeX::File* WebQueryZMATH::query( )
    {
        if ( m_wizard->exec() == QDialog::Accepted )
            return m_wizard->result();
        else
            return NULL;
    }

    int WebQueryZMATH::uniqueId()
    {
        return 0x0265ab5e;
    }

    QString WebQueryZMATH::title()
    {
        return i18n( "Zentralblatt MATH" );
    }

    WebQueryWizardZMATH::WebQueryWizardZMATH( const QString& caption, QWidget* parent, const char* name ): WebQueryWizard( caption, i18n( "Zentralblatt MATH" ), "http://www.zentralblatt-math.org/zmath/en/", FALSE, TRUE, parent, name )
    {
// nothing
    }

    WebQueryWizardZMATH::~WebQueryWizardZMATH()
    {
// nothing
    }

    void WebQueryWizardZMATH::startSearch()
    {
        setEnabled( FALSE );
        QApplication::setOverrideCursor( Qt::waitCursor );
        m_listViewResults->clear();

        KURL url = KURL( QString( "http://www.zentralblatt-math.org/zmath/en/search/?q=%1&count=%2&type=bibtex&format=short&display=all" ).arg( m_lineEditQuery->text().replace( "%", "%25" ).replace( " ", "+" ).replace("?","%3F" ).replace("&","%26" ) ).arg( m_spinBoxMaxHits->text() ) );
        QString tmpFile;
        if ( KIO::NetAccess::download( url, tmpFile, NULL ) )
        {
            BibTeX::FileImporterBibTeX importer( FALSE );
            importer.setIgnoreComments( TRUE );
            QFile inputFile( tmpFile );
            inputFile.open( IO_ReadOnly );
            BibTeX::File *tmpBibFile = importer.load( &inputFile );
            inputFile.close();
            KIO::NetAccess::removeTempFile( tmpFile );

            for ( BibTeX::File::ElementList::iterator it = tmpBibFile->begin(); it != tmpBibFile->end(); ++it )
            {
                BibTeX::Entry *entry = dynamic_cast<BibTeX::Entry*>( *it );
                if ( entry != NULL )
                    new ResultsListViewItem( m_listViewResults, new BibTeX::Entry( entry ) );
            }

            delete tmpBibFile;
        }
        else
            KMessageBox::error( this, KIO::NetAccess::lastErrorString() );

        setEnabled( TRUE );
        QApplication::restoreOverrideCursor();
    }

}
