//
// C++ Interface: srusearcher
//
// Description:
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
// Based on Tellico


#ifndef SRUSEARCHER_H
#define SRUSEARCHER_H

#include <searcher.h>
#include "searcherconfigwidget.h"

#include <kurl.h>
#include <kio/job.h>
#include <kconfig.h>

#include <qcstring.h> // for QByteArray
#include <qguardedptr.h>
#include "xslthandler.h"

/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/

class KLineEdit;
class KIntSpinBox;
class KComboBox;

class SRUSearcher;



class SRUConfigWidget : public SearcherConfigWidget
{
public:
    SRUConfigWidget(QWidget* parent, SRUSearcher* searcher = 0);
    virtual void updateSearcher();
private:
    KLineEdit* m_hostEdit;
    KIntSpinBox* m_portSpinBox;
    KLineEdit* m_pathEdit;
    KComboBox* m_formatCombo;
};



class SRUSearcher : public searcher
{
    Q_OBJECT
public:
    SRUSearcher(QObject *parent = 0, const char *name = 0);
    SRUSearcher(QString source_, QString host_, uint port, QString path_, QString syntax_,  QObject *parent = 0, const char *name = 0);

    virtual ~SRUSearcher();

    virtual QString source() const;
    virtual void setSource(const QString );
	virtual QString helpURL() {return QString::fromLatin1("http://www.loc.gov/standards/sru/specs/cql.html")  ; }
    virtual bool isSearching() const { return m_started; }
    // pubmed can search title, person, and keyword
    virtual void search(SearchKey key1, SearchKey key2, SearchKey key3 , const QString& value1, const QString& value2, const QString& value3, int operator1, int operator2);
	virtual void search(QString query);
    virtual void stop();
    virtual Type type() const { return SRU; }
    virtual void readConfig(KConfig* config, const QString& group);
    virtual void saveConfig(KConfig* config);
    virtual SearcherConfigWidget* configWidget(QWidget* parent);

    friend class SRUConfigWidget;
    virtual bool isWaitingRetrieveRange() const { return m_waitingRetrieveRange; }
    virtual void retrieveRange(unsigned int min, unsigned int max);
    virtual QStringList searchKey();
	virtual int maxSearchTerms() {return 100; }
    static QString defaultName();

private slots:
    void slotData(KIO::Job* job, const QByteArray& data);
    void slotComplete(KIO::Job* job);

private:
#if HAVE_XSLT
    XSLTHandler* m_MARC21XMLHandler;
    XSLTHandler* m_UNIMARCXMLHandler;
    bool initMARC21Handler();
    bool initUNIMARCHandler();
#endif
    void searchResults();
    void fetchResults();
    void getRecord(unsigned int);
    enum Step {
        Begin,
        Search,
        Wait,
        Fetch
    };

    Step m_step;
    KURL m_url;

    QString m_host;
    uint m_port;
    QString m_path;
    QString m_format;
    QByteArray m_data;
    QGuardedPtr<KIO::Job> m_job;
    bool m_started;
    int m_total;
    unsigned int startRec, endRec, currentRec;


};

#endif
