//
// C++ Implementation: grs1importer
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
// Adapted from Tellico
#include "grs1importer.h"

#include <qregexp.h>

GRS1Importer::TagMap* GRS1Importer::s_tagMap = 0;

// static
void GRS1Importer::initTagMap() {
	if(!s_tagMap) {
		s_tagMap =  new TagMap();
		s_tagMap->insert(TagPair(2, 1), QString::fromLatin1("title"));
		s_tagMap->insert(TagPair(2, 2), QString::fromLatin1("author"));
		s_tagMap->insert(TagPair(2, 4), QString::fromLatin1("year"));
		s_tagMap->insert(TagPair(2, 7), QString::fromLatin1("publisher"));
		s_tagMap->insert(TagPair(2, 31), QString::fromLatin1("publisher"));
		s_tagMap->insert(TagPair(2, 20), QString::fromLatin1("language"));
		s_tagMap->insert(TagPair(2, 21), QString::fromLatin1("keyword"));
		s_tagMap->insert(TagPair(3, QString::fromLatin1("edition")), QString::fromLatin1("edition"));
		s_tagMap->insert(TagPair(3, QString::fromLatin1("isbn/issn")), QString::fromLatin1("isbn"));
		s_tagMap->insert(TagPair(3, QString::fromLatin1("isbn")), QString::fromLatin1("isbn"));
		s_tagMap->insert(TagPair(3, QString::fromLatin1("notes")), QString::fromLatin1("note"));
		s_tagMap->insert(TagPair(3, QString::fromLatin1("note")), QString::fromLatin1("note"));
		s_tagMap->insert(TagPair(3, QString::fromLatin1("series")), QString::fromLatin1("series"));
		s_tagMap->insert(TagPair(3, QString::fromLatin1("physical description")), QString::fromLatin1("note"));
		s_tagMap->insert(TagPair(3, QString::fromLatin1("subtitle")), QString::fromLatin1("subtitle"));
	}
}

GRS1Importer::GRS1Importer(const QString& text): QObject(), m_text(text) {
	initTagMap();
}


GRS1Importer::~GRS1Importer()
{
}


BibEntry* GRS1Importer::import(){
	BibEntry *e = new BibEntry("book","");
	bool empty = true;

  // in format "(tag, tag) value"
	//QRegExp rx(QString::fromLatin1("\\s*\\((\\d+),\\s*(.+)\\s*\\)\\s*(.+)\\s*"));
	QRegExp rx(QString::fromLatin1("[\\s]*\\(([\\d]+),[\\s]*([^)(]+)[\\s]*\\)[\\s]*(.+)[\\s]*"));
    rx.setMinimal(false);
	QRegExp dateRx(QString::fromLatin1(",[^,]*\\d{3,4}[^,]*")); // remove dates from authors
	QRegExp pubRx(QString::fromLatin1("([^:]+):([^,]+),?")); // split location and publisher

	bool ok;
	int n;
	QVariant v;
	QString tmp, field, val;
	if(m_text.isEmpty()) {
		return 0;
	}
	QTextStream t(&m_text, IO_ReadOnly);
	for(QString line = t.readLine(); !line.isNull(); line = t.readLine()) {
		if(!rx.exactMatch(line)) {
			continue;
		}
		n = rx.cap(1).toInt();
		v = rx.cap(2).toInt(&ok);
		
		if(!ok) {
			v = rx.cap(2).lower();
		}

		field = (*s_tagMap)[TagPair(n, v)];
		if(field.isEmpty()) {
			continue;
		}
    // assume if multiple values, it's allowed
		val = rx.cap(3).stripWhiteSpace();
		if(val.isEmpty()) {
			continue;
		}
		empty = false;
		if(field == QString::fromLatin1("title")) {
			val = val.section('/', 0, 0).stripWhiteSpace(); // only take portion of title before slash
		} else if(field == QString::fromLatin1("author")) {
			val.replace(dateRx, QString::null);
		} else if(field == QString::fromLatin1("publisher")) {
			int pos = val.find(pubRx);
			if(pos > -1) {
				e->setField("address", const_cast<char*>((pubRx.cap(1)).ascii()));
				e->setStringMacroIndicator("address", false);
				val = pubRx.cap(2);
			}
		}

		tmp = e->getField(field.latin1());
		if(!tmp.isEmpty()) {
			tmp += QString::fromLatin1("; ");
		}
		e->setField(const_cast<char*>(field.latin1()), const_cast<char*>((tmp + val).ascii()));
		e->setStringMacroIndicator(field.latin1(), false);
	}

	return e;	
}


#include "grs1importer.moc"
