//
// C++ Interface: linefieldwidget
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef GUILINEFIELDWIDGET_H
#define GUILINEFIELDWIDGET_H

#include "fieldwidget.h"
#include <qcheckbox.h>
class KLineEdit;

class KPushButton;
class KPopupMenu;

namespace GUI {

/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/
class LineFieldWidget : public FieldWidget
{
Q_OBJECT
		
public:
    LineFieldWidget(QString _name, RefField* field,  QStringList macroKeys, QWidget *parent = 0, const char *name = 0);

    ~LineFieldWidget();
	virtual void setText(QString );
	virtual void setMacro(bool macro) {m_stringMacroIndicator->setChecked(macro); }
	virtual QString getText();
	virtual bool getMacro(void) { return m_stringMacroIndicator->isChecked(); }
	virtual void setAutoCompletion(QStringList);
	
private slots:
	void slotMacroMenuActivated(int);		
	
private:
	KLineEdit *m_lineEdit;
	QCheckBox *m_stringMacroIndicator;
	KPushButton *m_stringMacroSelect;	
	KPopupMenu *m_stringMacroMenu;

};

}

#endif
