//
// C++ Implementation: copyfieldcontent
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "copyfieldcontent.h"

#include "bibentrydeftable.h"
#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qhbox.h>
#include <qwhatsthis.h>


CopyFieldContentDlg::CopyFieldContentDlg(bool selected, QWidget *parent, const char *name)
 :KDialogBase ( parent, name , true, i18n ( "Copy Field Content" ), KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, false )
{
	QWidget* page = new QWidget ( this );
	setMainWidget ( page );
	QVBoxLayout* l = new QVBoxLayout ( page, 0, KDialog::spacingHint() );

	QHBox* box1 = new QHBox ( page );
	box1->setSpacing ( KDialog::spacingHint() );
	
	QLabel *srcfieldLabel = new QLabel(i18n("Source field:"), box1);
	m_sourceField = new KComboBox(true, box1);
	QWhatsThis::add(m_sourceField, i18n("Enter or select from the list the source field.") );
	l->addWidget(box1);
	srcfieldLabel->setBuddy(m_sourceField);
	
	QHBox* box2 = new QHBox ( page );
	box2->setSpacing ( KDialog::spacingHint() );
	
	QLabel *destfieldLabel = new QLabel(i18n("Destination field:"), box2);
	m_destinationField = new KComboBox(true, box2);
	QWhatsThis::add(m_destinationField, i18n("Enter or select from the list the destiniation field.") );
	l->addWidget(box2);
	destfieldLabel->setBuddy(m_destinationField);
	
	int width;
	if (srcfieldLabel->sizeHint().width() > destfieldLabel->sizeHint().width())
		width = srcfieldLabel->sizeHint().width();
	else
		width = destfieldLabel->sizeHint().width();
	srcfieldLabel->setFixedWidth(width);
	destfieldLabel->setFixedWidth(width);
		
	m_clearSourceContent = new QCheckBox( i18n ( "Clear the content of the source field" ), page );
	m_clearSourceContent->setChecked(true);
	l->addWidget(m_clearSourceContent);
	
	m_optionGroup = new QVGroupBox(i18n("Apply change to"), page);
    l->addWidget(m_optionGroup);

    m_buttonGroup = new QButtonGroup(page);
    m_allEntrySelect = new QRadioButton(i18n("All references"), m_optionGroup);
	QWhatsThis::add(m_allEntrySelect, i18n("Apply change to all references in the current document.") );
    m_selectedEntrySelect = new QRadioButton(i18n("Only selected references"), m_optionGroup);
	QWhatsThis::add(m_selectedEntrySelect, i18n("Apply change to only selected references in the main list view or in the group view.") );
	m_buttonGroup->hide();

    m_buttonGroup->insert(m_allEntrySelect);
    m_buttonGroup->insert(m_selectedEntrySelect);
	
	if (selected){
	    m_allEntrySelect->setChecked(0);
    	m_selectedEntrySelect->setChecked(1);
		m_selectedEntrySelect->setEnabled(true);
	}
	else{
		m_allEntrySelect->setChecked(1);
    	m_selectedEntrySelect->setChecked(0);	
		m_selectedEntrySelect->setEnabled(false);
	}
	
	
	m_sourceField->insertStringList( BibEntryDefTable::self()->getFieldNames());	
	m_destinationField->insertStringList( BibEntryDefTable::self()->getFieldNames());	
	
		
    m_sourceField->setCurrentText("");
	m_destinationField->setCurrentText("");
	
	QWidget *dumm1 = new QWidget(box1);
	box1->setStretchFactor(dumm1, 1);
	QWidget *dumm2 = new QWidget(box2);
	box1->setStretchFactor(dumm2, 1);
	this->setMinimumWidth(300);
}


CopyFieldContentDlg::~CopyFieldContentDlg()
{
}


#include "copyfieldcontent.moc"
