/***************************************************************************
 *   Copyright (C) 2005 by Siraj Razick                                    *
 *   siraj@kdemail.net                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "spinxbutton.h"
///#include "../imagesource/kbfx.xpm"
#include <stdio.h>
#include <kpixmapeffect.h>
#include <kimageeffect.h>
#include <qbutton.h>
extern const char *kbfx[];


SpinxButton::SpinxButton (QWidget * parent, const char *name):
QLabel (parent, name)
{

  setLineWidth (0);
  setScaledContents (false);

}




void
SpinxButton::paintEvent (QPaintEvent * pe)
{


  const QRect r = pe->rect ();
  QPainter p;
  if (!_normal.isNull ())
    {
      p.begin (this);
      p.drawPixmap (r, _current);
      p.end();
    }


}


QPixmap
SpinxButton::getKDEIcon (QString src)
{
  KIconLoader *iconload = KGlobal::iconLoader ();
  QString iconfile = iconload->iconPath (src, KIcon::Desktop, false);
  return QPixmap (iconfile);
}





void
SpinxButton::setPixmap (QPixmap normal, QPixmap hover)
{

  _normal = normal;

  if (_normal.isNull ())
    {
      //fallback to default skin...
      _normal = getKDEIcon ("menu_button_logout");
    }

  _hover = hover;

  if (_hover.isNull ())
    {
      _hover = QImage ("menu_button_logout_hover");
    }
  _current = _normal;
}


SpinxButton::~SpinxButton ()
{


}


#include "spinxbutton.moc"
