#include "vistalistbox.h"
#include <qimage.h>
#include <qpixmap.h>
#include <qtimer.h>





void
VistaListBoxItem::paint (QPainter * painter)
{


  itemHeight = listImageNormal.height ();
  bool in_list_box = listBox ()
    && listBox ()->viewport () == painter->device ();

  QRect r (0, 0, width (listBox ()), height (listBox ()));

//  painter->eraseRect (r);
  painter->drawPixmap (r, listImageNormal);
  painter->drawPixmap (5, 6, iconPixmap, 0, 0, iconPixmap.height (),
		       iconPixmap.width ());

  QFont *let = new QFont ();
  if (!type)
    let->setBold (FALSE);
  else
    let->setBold (FALSE);
  let->setPointSize (8);
  int _applicationTextHeight;	// +(let->pixelSize()*2);

  if (type)
    _applicationTextHeight =
      (((listImageNormal.height () - let->pointSize ())) / 2) - 2;
  else
    _applicationTextHeight = let->pointSize () + 1;

  painter->setPen (QColor (0, 0, 0));

  painter->setFont (*let);

  painter->drawText (iconPixmap.width () + 10, _applicationTextHeight,
		     width (listBox ()), height (listBox ()), Qt::SingleLine,
		     *text);

  if (!type)
    {
      painter->setPen (QColor (255, 220, 125));

      painter->drawLine (iconPixmap.width () + 10,
			 listImageNormal.height () / 2, 200,
			 listImageNormal.height () / 2);
      painter->setPen (QColor (0, 0, 0));
    }


  painter->setPen (QColor (120, 125, 102));
  let->setBold (FALSE);
  let->setPointSize (8);
  painter->setFont (*let);
  painter->drawText (iconPixmap.width () + 10,
		     (_applicationTextHeight + let->pointSize () + 10),
		     width (listBox ()), height (listBox ()), Qt::SingleLine,
		     application_comment);

  if ((_blocked==1 && type) || (in_list_box && isCurrent ()))
    {
      //    listBox ()->style ().drawPrimitive (QStyle::PE_FocusRect, painter, r,
      //                                  listBox ()->colorGroup ());

      painter->drawPixmap (r, listImageMouseOver);
      if (!iconPixmap.isNull ())
	{
	  QPixmap tmp = iconPixmap;
	  QImage zoom = iconPixmap.convertToImage ();
	  zoom = zoom.smoothScale (40, 40);
	  iconPixmap.convertFromImage (zoom);
	  painter->drawPixmap (5, 6, iconPixmap, 0, 0, zoom.height (),
			       zoom.width ());
	  iconPixmap = tmp;
	}
      // painter->drawText (iconPixmap.width () + 10, 5, width (listBox ()),
//                       height (listBox ()), Qt::SingleLine, *text);

      let->setBold (true);
      let->setPointSize (8);
      painter->setFont (*let);

      painter->setPen (QColor (0, 0, 0));

      if (type)
	{

	  painter->drawText (iconPixmap.width () + 10, _applicationTextHeight,
			     width (listBox ()), height (listBox ()),
			     Qt::SingleLine, *text);



	}
      else
	{

	  painter->drawText (iconPixmap.width () + 18, _applicationTextHeight,
			     width (listBox ()), height (listBox ()),
			     Qt::SingleLine, *text);


	}

      if (!type)
	{
	  painter->setPen (QColor (255, 220, 125));

	  painter->drawLine (iconPixmap.width () + 18,
			     listImageNormal.height () / 2, 200,
			     listImageNormal.height () / 2);

	  painter->setPen (QColor (255, 0, 0));

	  painter->drawText (iconPixmap.width () + 18,
			     (_applicationTextHeight + let->pointSize () +
			      10), width (listBox ()), height (listBox ()),
			     Qt::SingleLine, application_comment);

	  painter->setPen (QColor (0, 0, 0));
	}

    }
  //_blocked = 0;
}

void
VistaListBoxItem::setLabelText (QString * name)
{
  text = name;
}

void
VistaListBoxItem::setLabelIcon (QPixmap icon)
{

  iconPixmap = icon;

}


void
VistaListBoxItem::setLabelIcon (QString icon)
{
  application_icon = icon;
  setLabelIcon (QPixmap (icon));
}

void
VistaListBoxItem::setHeight (int h)
{

  itemHeight = h;

}

void
VistaListBoxItem::setWidth (int w)
{

  itemWidth = w;

}

void
VistaListBoxItem::setApplicationProperties (QString appname, QString exename,
					    QString desktopfile)
{

  application_name = new QString (appname);
  application_exe = (exename);
  application_desktop_file = new QString (desktopfile);
}


void
VistaListBoxItem::setTilePixmap (QPixmap tile)
{

  if (tile.isNull ())
    {
      //  qDebug ("Tile Image is NULL:using built in resources");
      QImage tileimg (listboxtile_xpm);
      QPixmap tilepixmap (tileimg);
      listImageNormal = tileimg;
    }
  else
    {
      listImageNormal = tile;
    }

}

void
VistaListBoxItem::setTileHoverPixmap (QPixmap hovertile)
{
  if (hovertile.isNull ())
    {
// qDebug ("Tile Image is NULL:using built in resources");
      QImage tileimg (listboxhover);
      QPixmap tilepixmap (tileimg);
      listImageMouseOver = tileimg;
    }
  else
    {
      listImageMouseOver = hovertile;
    }
}
