/***************************************************************************
 *   Copyright (C) 2005 by Siraj Razick                                    *
 *   siraj@kdemail.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "kbfxvista.h"
#include "settings.h"
#include <kglobal.h>
#include <qbitmap.h>
#include <stdio.h>
#include <krun.h>
#include <kpassivepopup.h>

kbfxvista::kbfxvista (const QString & configFile, Type type, int actions,
		      QWidget * parent, const char *name):
KPanelApplet (configFile, type, actions, parent, name),DCOPObject("kbfxInterface")
{
  wait_dcop = 0;
  dcop = new DCOPClient ();
  dcop->attach();
  setAcceptDrops (true);
  readConfig ();
  blocked = 0;
  _clicked = 0;
  button = new kbfx_vista_button(this);
 
  connect (button, SIGNAL (skinLoadComplete ()), button,SLOT (skinLoadCompleteSlot ()));
  connect (this, SIGNAL (enter ()), button, SLOT (onMouseOverSlot ()));
  connect (this, SIGNAL (leave ()), button, SLOT (onMouseLeaveSlot ()));
  connect (this, SIGNAL (clicked ()), button, SLOT (onMouseClickSlot ()));

  button->kbfx_vista_button_loadSkins (skin,skin_hover,skin_pressed);
  button->installEventFilter (this);
  button->show();

  QTimer::singleShot( 500, this, SLOT(menuInit()) );
 

}



void kbfxvista::menuInit()
{
    menu = new KPopupMenu(this);
    a = new vista(menu) ;
    readConfig();
    QString  path = QDir::homeDirPath () + QString ("/.kbfx/");
    QString  themepath = path + QString ("bartheme/");

    QDir dir = QDir::home ();
    
    if (!dir.exists (themepath))
    {
        dir.mkdir (".kbfx/bartheme");
   
    }

a->setThemeName(theme);

QPixmap  top ;
QImage topimg (theme+"/"+"topbg.png");
top.convertFromImage (topimg);


QPixmap  bot ;
QImage botimg (theme+"/"+"botbg.png");
bot.convertFromImage (botimg);

QPixmap  bgi ;
QImage   bgiimg (theme+"/"+"bg.png");
bgi.convertFromImage (bgiimg);

QPixmap  tab ;
QImage tabimg (theme+"/"+"tabbg.png");
tab.convertFromImage (tabimg);

QPixmap listboxbg;
QImage listboxbgimg(theme + "/" + "listboxbg.png");
listboxbg.convertFromImage(listboxbgimg);

QPixmap tile;
QImage tileimg(theme + "/" + "tilenormal.png");
tile.convertFromImage(tileimg);

QPixmap tileHover;
QImage tilehoverimg(theme + "/" + "tilehover.png");
tileHover.convertFromImage(tilehoverimg);

QPixmap rhstile;
QImage rhsimg(theme + "/" + "rhstile.png");
rhstile.convertFromImage(rhsimg);

QPixmap rhshtile;
QImage rhshimg(theme + "/" + "rhshovertile.png");
rhshtile.convertFromImage(rhshimg);

QPixmap logoutimg;
QImage logout(theme + "/" + "logout.png");
logoutimg.convertFromImage(logout);

QPixmap lockimg;
QImage lock(theme + "/" + "lock.png");
lockimg.convertFromImage(lock);

QPixmap lockimghover;
QImage lockhover(theme + "/" + "lockhover.png");
lockimghover.convertFromImage(lockhover);

QPixmap logoutimghover;
QImage logouthover(theme + "/" + "logouthover.png");
logoutimghover.convertFromImage(logouthover);

QPixmap person;
QImage personimg(theme + "/" + "dudebox.png");
person.convertFromImage(personimg);



QPixmap listimg;
QImage list(theme + "/" + "appfind.png");
listimg.convertFromImage(list);


QPixmap findimg;
QImage find(theme + "/" + "find.png");
findimg.convertFromImage(find);



if (listboxbg.isNull())
	qDebug("ListBox Pixmap setting failed");


QPixmap  maski; 
QImage maskiimg (theme+"/"+"mask.png");
maski.convertFromImage (maskiimg);


if (maski.isNull() || top.isNull() || tab.isNull() || bgi.isNull() )
{
qDebug("Null Pixmaps found");
top.convertFromImage   (QImage(topbg));
bot.convertFromImage   (QImage(botbg));
bgi.convertFromImage   (QImage(bg));
tab.convertFromImage   (QImage(tabbg));
maski.convertFromImage (QImage(mask));
//logoutimg.convertFromImage(QImage(logout));
//lockimg.convertFromImage(QImage(lock));
//findimg.convertFromImage(QImage(find));
//listimg.convertFromImage(QImage(appfind));

}

a->KappbarSetTileImages(tile,tileHover,rhstile,rhshtile);
a->KAppBarSetTheme(top,bgi,tab,bot,maski,listboxbg,logoutimg,logoutimghover,lockimghover,lockimg,listimg,findimg,person);


if(!maski.isNull())
{

if ( !maski.mask()) 
{
	if(! maskiimg.hasAlphaBuffer())
	{
	qDebug("Creating AplhaMask");
	QBitmap bitmap;
	bitmap= maskiimg.createAlphaMask();
	maski.setMask(bitmap);
	}
	else
	{
	qDebug("Creating Hurestic Mask");
	QBitmap bitmap;
	bitmap = maskiimg.createHeuristicMask();
	maski.setMask(bitmap);
	}
}

if(maski.mask())
	menu->setMask(*maski.mask());


}

menu->insertItem(a,0);

}


kbfxvista::~kbfxvista ()
{
  saveConfig ();
  delete (button);
}


void
kbfxvista::about ()
{
    KAboutData data("kbfxVista",
                            I18N_NOOP("kbfx Applet"),
                            " 0.4.8rc2cvs",
                            I18N_NOOP("FIXME:KDE needs a Better Application Menu"),
                            KAboutData::License_GPL_V2,
                            "(c) 2005, Siraj Razick");

    data.addAuthor("Siraj Raizck",
                        I18N_NOOP("Author/Maintainer"),
                        "siraj@kdemail.net",
                        "http://www.linuxlots.com/~siraj/");
    
    data.addAuthor("Mensur Zahirovic (Nick:Nookie)","System Design,QA Lead, And Web Master ","info@pcagenten.se","http://www.kbfx.org");
	
    data.addAuthor("Akhmad Fathonih",
                        I18N_NOOP("Kbfx Configuration Manager"),
                        "akhmadf@gmail.com",
                        "http://blog.neofreko.com");
                        
        data.addAuthor("bfman" ,"Sorceforge.net Package Manager","http://www.sf.net/projects/kbfx");

	
    data.addCredit   ( "Nookie", 
                        "Thanx Nookie and his company PC Agenten for hosting the homepage", 
                         "http://www.pcageten.se", "info@pcagenten.se"
                        ) ;


	//data.addCredit("Ting <TODO> add the real name",
          //              I18N_NOOP("Developer"),
            //         "",
              //         "tingxx@gmail.com");

	data.addCredit("Asif Ali Rizwaan with lots of themes and ideas",
                        I18N_NOOP("Artist"),
                     "",
                       "");
	data.addCredit("Dominik with code and ideas",
                        I18N_NOOP("Developer"),
                     "",
                       "");
	data.addCredit("Victor with themes and ideas",
                        I18N_NOOP("Developer"),
                     "",
                       "");

	data.addCredit("Victor with themes and ideas",
                        I18N_NOOP("Developer"),
                     "",
                       "");
	data.addCredit("all who gave Open Comments on kde-look",
                        I18N_NOOP("Developer"),
                     "",
                       "http://www.kde-look.org");
	data.addCredit("P.K with themes and ideas",
                        I18N_NOOP("Developer"),
                     "",
                       "");

    KAboutApplication dialog(&data);
    dialog.exec();
}


void
kbfxvista::help ()
{
  KMessageBox::information (0, i18n ("Visit http://www.kbfx.org/help.php"));
}


void
kbfxvista::preferences ()
{

KRun::runCommand ("kcmshell kcmkbfx");


}

int
kbfxvista::widthForHeight (int height) const 
{
  
  height = height;
  QImage norm (skin);
  if(norm.isNull())
	return 64;
  return  norm.width();
}

int
kbfxvista::heightForWidth (int width) const 
{
 //  readConfig();
  width = width;
  QImage norm (skin);
  if(norm.isNull())
	return 64;
  return  norm.height();
}

void
kbfxvista::resizeEvent (QResizeEvent * e)
{
  KPanelApplet::resizeEvent (e);
}


void kbfxvista::showStartMenu()
{

    QByteArray data;
    QByteArray rdata;
    QDataStream arg (data, IO_WriteOnly);
    QCString replytype;
    blocked = 1;
    
    //bartype = KbfxCfg::menuType();
    
    if(bartype  == "kmenu" && _clicked == 0)
    {
        this->showKmenu();
    }
    
  if (_clicked == 0)
    {
        arg << menupos();
        if (!dcop->send("kicker","kbfxInterface","showKbfxMenu(QPoint)",data))
        {
            kdWarning () << "**KBFX-APPLET-FATAL_ERROR:Could not send DCOP command\n";
        }
    }
}

bool
kbfxvista::eventFilter (QObject * o, QEvent * e)
{
o = o;

  switch (e->type ())
    {

    case QEvent::Enter:
      {
		emit enter ();

//	 pop->setView( button );
				QCursor   kbfxCursor;
			kbfxCursor.setShape(Qt::PointingHandCursor); 
			this->setCursor((const QCursor ) kbfxCursor);	

	return TRUE;
      }
    case QEvent::Leave:
      {
	if ( blocked == 0)
		emit leave ();
	return TRUE;
      }
    case QEvent::MouseButtonPress:
      { 
//	pop->hide();
	  emit clicked();
	showStartMenu();
	if(_clicked ==1)
	_clicked=0;
	else if (this->hasMouse())
	{
	_clicked = 1;
	}
		return TRUE;
      }
    case QEvent::MouseButtonRelease:
	{
//	  pop->hide();
//	  emit clicked();
	  return TRUE;
	}
    default:
          return FALSE;

    }

}


extern "C"
{
  KPanelApplet *init (QWidget * parent, const QString & configFile)
  { 
    KGlobal::locale ()->insertCatalogue ("kbfxvista");
    return new kbfxvista (configFile, KPanelApplet::Normal,
			  KPanelApplet::About | KPanelApplet::
			  Help | KPanelApplet::Preferences, parent,
			  "kbfxvista");
  }
}

void kbfxvista::readConfig()

{
    static_cast<KConfigSkeleton*>(KbfxCfg::self())->readConfig();

    skin = KbfxCfg::normal();

    skin_pressed = KbfxCfg::pressed();

    skin_hover = KbfxCfg::hover();

    fx_on = KbfxCfg::enableGlow();
   tooltip  = KbfxCfg::tooltips();
    kicker_auto_ajust = KbfxCfg::autoAdjustKicker();
    bartype = KbfxCfg::menuType();
    kdDebug() << "Menutype: " << KbfxCfg::menuType() << endl;
    theme = KbfxCfg::themeFolder();


}

void kbfxvista::saveConfig()
{
    KbfxCfg::setNormal(skin);

    KbfxCfg::setPressed(skin_pressed);

    KbfxCfg::setHover(skin_hover);

    KbfxCfg::writeConfig();
}



void
kbfxvista::dropEvent (QDropEvent * e)
{
    e->accept ();
    e->acceptAction ();
    
    QStrList ls;
    QString filename;
    QUriDrag::decode (e, ls);
    filename = QUriDrag::uriToLocalFile (ls.at (0));
    skin_hover = QUriDrag::uriToLocalFile(ls.at(1)); 
    skin_pressed = QUriDrag::uriToLocalFile(ls.at(2)); 
    skin = QUriDrag::uriToLocalFile (ls.at (0));
  
    QPixmap droped = QImage (filename);
    if (droped.isNull ())
    {
        KMessageBox::information (0, i18n ("Pixmap creation failed"));
        return ;
    }
    else
    {
        //FIXME:Code Wanted 
        button->kbfx_vista_button_loadSkins (skin,skin_hover,skin_pressed);
    }

    /* time to se the hiddent images */
    
   if(kicker_auto_ajust)
    {
        QByteArray data;
        QDataStream
        arg (data, IO_WriteOnly);
        arg<< droped.height() + 3;
        if (!dcop->send ("kicker", "Panel", "setPanelSize(int)", data))
            kdWarning () << "Could not send DCOP command\n";
    }
   // button->kbfx_vista_button_loadSkins (skin,skin_hover,skin_pressed);
    saveConfig();
 	
}

void
kbfxvista::dragEnterEvent (QDragEnterEvent * e)
{
  //if (QImageDrag::canDecode (e))
  e->accept ();
}

void kbfxvista::showMenu()
{
    if(KbfxCfg::menuType()=="kmenu")
    {
        this->showKmenu();
    }
    else
    {
        kbfxpop(menupos());
    }
}

void kbfxvista::showKbfxMenu(QPoint x)
{
 x=x;
    if(KbfxCfg::menuType()=="kmenu")
    {
        this->showKmenu();
    }
    else
    {
        kbfxpop(menupos());
    }
	blocked = 0;
	emit leave();
}

void kbfxvista::notifyConfigChange()
{
    readConfig();
    button->kbfx_vista_button_loadSkins (skin,skin_hover,skin_pressed);
    menuInit();
    emit enter();
    emit leave();
}
