/***************************************************************************
 *   Copyright (C) 2005 by Siraj Razick                                    *
 *   siraj@kdemail.net                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kbfx_vista_button.h"
#include "../imagesource/kbfx.xpm"
#include <stdio.h>
#include <kpixmapeffect.h>
#include <kimageeffect.h>
#include <qbutton.h>
#include <qtimer.h>

kbfx_vista_button::kbfx_vista_button(QWidget *parent, const char *name):QLabel(parent,name,WNoAutoErase)
{
	
   setLineWidth (0);
   setScaledContents (false);
   fxon = false;
     QTimer *t = new QTimer( this );
        connect( t, SIGNAL(timeout()), SLOT(update()) );
        t->start( 1000, FALSE );	
}

void kbfx_vista_button::kbfx_vista_button_setFx(bool t)
{

 	fxon = t;

}



void kbfx_vista_button::paintEvent(QPaintEvent * pe)
{
const QRect r = pe->rect();
QPainter p;
if(!normal_skin.isNull())
{
p.begin(this);
p.drawPixmap(r,current_skin);
}

}

void kbfx_vista_button::timerEvent(QTimerEvent * e)
{
//	this->update();
}

int kbfx_vista_button::kbfx_vista_button_setPixmap(QPixmap skin)
{
    if (!skin.isNull())
    {    
  	this->resize(skin.width(),skin.height());
	this->setPixmap(skin);
	current_skin = skin;
	this->repaint();
     }


    return 1;
}


int kbfx_vista_button::kbfx_vista_button_loadSkins(QString normal , QString hover , QString pressed)
{

  normal_skin = QImage(normal);
    
    if ( normal_skin.isNull())
    {
        //fallback to default skin...
        normal_skin = QImage(kbfx);
    }
  
    over_skin = QImage(hover);
    
    if ( over_skin.isNull())
    {
        over_skin = QImage(normal);
    }
    pressed_skin = QImage(pressed);
    
    if (pressed_skin.isNull())
    {
        pressed_skin = QImage(normal);
    }
  
  
  emit skinLoadComplete();
    
    return 1;
    
}


kbfx_vista_button::~kbfx_vista_button()
{


}

void kbfx_vista_button::skinLoadCompleteSlot()
{
       kbfx_vista_button_setPixmap(normal_skin);

}

void  kbfx_vista_button::onMouseOverSlot()
{
    kbfx_vista_button_setPixmap(over_skin);
}


void kbfx_vista_button::onMouseLeaveSlot()
{
    kbfx_vista_button_setPixmap(normal_skin);
}

void kbfx_vista_button::onMouseClickSlot()
{
//FIXME:Need code for Kde image FX : and ahkmed need to use this on his config
/*
 QImage kimg (pressed_skin.convertToImage());
 kbfx_vista_button_setPixmap( 
 QPixmap (KImageEffect::blend ( QButton().paletteBackgroundColor (),kimg,0.5)));  
*/ 

kbfx_vista_button_setPixmap(pressed_skin);
}

void kbfx_vista_button::startMenuDone(int callId, const QCString& replyType, const QByteArray &replyData)
{
    kbfx_vista_button_setPixmap(normal_skin);
}

#include "kbfx_vista_button.moc"
