/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003-2004 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-bookmark-menu.c 2296 2005-08-17 10:38:05Z ikezoe $
 */

#include "kz-bookmark-menu.h"

#include <glib/gi18n.h>

#include "kazehakase.h"
#include "utils.h"
#include "kz-bookmark-menu-item-list.h"
#include "kz-bookmark-menu-item.h"
#include "kz-bookmark-folder-menu-item.h"
#include "kz-bookmark-separator-menu-item.h"

GtkWidget *
kz_bookmark_menu_create_submenu (KzBookmark *folder, KzWindow *kz)
{
	GtkWidget *submenu;
	GtkWidget *menu_item;

	g_return_val_if_fail(KZ_IS_BOOKMARK(folder), NULL);
	g_return_val_if_fail(kz_bookmark_is_folder(folder), NULL);
	g_return_val_if_fail(KZ_IS_WINDOW(kz), NULL);

	submenu = gtk_menu_new();

	menu_item = kz_bookmark_menu_item_new(kz, folder);
	if (menu_item)
	{
		gtk_menu_shell_append(GTK_MENU_SHELL(submenu), menu_item);
		gtk_widget_show(menu_item);
	}

	/* separator */
	menu_item = gtk_separator_menu_item_new();
	gtk_menu_shell_append(GTK_MENU_SHELL(submenu), menu_item);
	gtk_widget_show(menu_item);

	kz_bookmark_menu_append_menuitems (GTK_MENU_SHELL(submenu), kz, folder);

	return submenu;
}


void
kz_bookmark_menu_append_menuitems (GtkMenuShell *shell, KzWindow *kz, 
				   KzBookmark *folder)
{
	GList *children, *node;

	g_return_if_fail(GTK_IS_MENU_SHELL(shell));
	g_return_if_fail(KZ_BOOKMARK(folder));
	g_return_if_fail(kz_bookmark_is_folder(folder));

	kz_bookmark_menu_item_list_new(shell, kz, folder);

	/* children */
	children = kz_bookmark_get_children(folder);
	for (node = children; node; node = g_list_next(node))
	{
		KzBookmark *child = node->data;
		GtkWidget *widget;

		if (kz_bookmark_is_folder(child))
			widget = kz_bookmark_folder_menu_item_new(kz, child);
		else if (kz_bookmark_is_separator(child))
			widget = kz_bookmark_separator_menu_item_new(kz, child);
		else
			widget = kz_bookmark_menu_item_new(kz, child);

		gtk_menu_shell_append(shell, widget);
		gtk_widget_show(widget);
	}
	g_list_free(children);
}


static void
remove_item (GtkWidget *child, gpointer data)
{
	if (KZ_IS_BOOKMARK_BASE_MENU_ITEM(child))
		gtk_container_remove(GTK_CONTAINER(child->parent), child);
}


void
kz_bookmark_menu_remove_menuitems (GtkMenuShell *shell, KzWindow *kz)
{
	g_return_if_fail(GTK_IS_MENU_SHELL(shell));

	gtk_container_foreach (GTK_CONTAINER (shell),
			       remove_item, NULL);
}


