// -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-

//
//  Copyright (C) 2002-2003 Hiroyuki Ikezoe
//  Copyright (C) 2003 Takuro Ashie
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifdef HAVE_CONFIG_H
#	include "config.h"
#endif

#include <gtkmozembed.h>
#include <nsCOMPtr.h>
#include <nsIGenericFactory.h>
#include <nsIComponentRegistrar.h>

#include "mozilla.h"
#include "mozilla-prefs.h"
#include "kz-mozfilepicker.h"
#include "kz-mozlauncher.h"
#include "kz-mozprogresslistener.h"
#include "kz-profile.h"
#include "kz-proxy-item.h"
#include "kazehakase.h"


NS_GENERIC_FACTORY_CONSTRUCTOR(KzFilePicker)
NS_GENERIC_FACTORY_CONSTRUCTOR(KzContentHandler)
NS_GENERIC_FACTORY_CONSTRUCTOR(KzMozProgressListener)


static const nsModuleComponentInfo sAppComps[] = {
	{
		KZ_DOWNLOAD_CLASSNAME,
		KZ_DOWNLOAD_CID,
		NS_DOWNLOAD_CONTRACTID,
		KzMozProgressListenerConstructor
	},
	{
		KZ_FILEPICKER_CLASSNAME,
		KZ_FILEPICKER_CID,
		KZ_FILEPICKER_CONTRACTID,
		KzFilePickerConstructor
	},
	{
		NS_IHELPERAPPLAUNCHERDLG_CLASSNAME,
		KZ_CONTENTHANDLER_CID,
		NS_IHELPERAPPLAUNCHERDLG_CONTRACTID,
		KzContentHandlerConstructor
	},
};
static const int sNumAppComps = G_N_ELEMENTS(sAppComps);


static gboolean
mozilla_register_components (void)
{
	gboolean ret = TRUE;
	nsresult rv;

	nsCOMPtr<nsIComponentRegistrar> cr;
	rv = NS_GetComponentRegistrar(getter_AddRefs(cr));
	NS_ENSURE_SUCCESS(rv, rv);

	for (int i = 0; i < sNumAppComps; i++)
	{
		nsCOMPtr<nsIGenericFactory> componentFactory;
		rv = NS_NewGenericFactory(getter_AddRefs(componentFactory),
					  &(sAppComps[i]));
		if (NS_FAILED(rv))
		{
			ret = FALSE;
			continue;  // don't abort registering other components
		}

		rv = cr->RegisterFactory(sAppComps[i].mCID,
					 sAppComps[i].mDescription,
					 sAppComps[i].mContractID,
					 componentFactory);
		if (NS_FAILED(rv))
			ret = FALSE;
	}

	return ret;
}


static void 
destroy_browser_cb (GtkMozEmbed *embed, GtkWidget *transient_window)
{
	gtk_widget_destroy(GTK_WIDGET(transient_window));
}


static void
new_window_orphan_cb (GtkMozEmbedSingle *embed, GtkMozEmbed **retval,
		      guint chromemask, gpointer data)
{
	// FIXME! but I don't have any nice idea...
	GtkWidget *newWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	GtkMozEmbed *newBrowser = GTK_MOZ_EMBED(gtk_moz_embed_new());

	gtk_container_add(GTK_CONTAINER(newWindow), GTK_WIDGET(newBrowser));
	g_signal_connect(G_OBJECT(newBrowser),"destroy_browser",
			 G_CALLBACK(destroy_browser_cb),newWindow);
	*retval = GTK_MOZ_EMBED(newBrowser);
}


static void
cb_profile_changed (KzProfile *profile,
		    const gchar *section,
		    const gchar *key,
		    const gchar *old_value,
		    gpointer data)
{
	gchar proxy_name[1024];

	switch (key[0])
	{
	case 'o': // override_user_agent
		break;
	case 'p':
		if (strcmp(key, "proxy_name") == 0 &&
		    KZ_CONF_GET(section, key, proxy_name, STRING))
		{
			KzProxyItem *item = kz_proxy_find(proxy_name);
			if (item) {
				mozilla_prefs_set_proxy(item);
				g_object_unref(G_OBJECT(item));
			}
		}
		break;
	case 'u': // user_agent
		break;
	}
}


extern "C" void
mozilla_init (void)
{
	GtkMozEmbedSingle *single = NULL;

	mozilla_prefs_init();

	gtk_moz_embed_push_startup();

	mozilla_prefs_set();

	//
	// get the singleton object and hook up to its new window callback
	// so we can create orphaned windows.
	//
	single = gtk_moz_embed_single_get();
	if (!single) {
		g_error("Failed to get singleton embed object!");
		return;
	}

	g_signal_connect(G_OBJECT(single), "new_window_orphan",
			 G_CALLBACK(new_window_orphan_cb), NULL);

	g_signal_connect(G_OBJECT(kz_global_profile), "changed::Global",
			 G_CALLBACK(cb_profile_changed), NULL);


	mozilla_register_components();
}


extern "C" void
mozilla_exit (void)
{
	gtk_moz_embed_pop_startup();
}
