/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 *  Popup actions for main window.
 */

#ifndef __KZ_ACTIONS_POPUP_H__
#define __KZ_ACTIONS_POPUP_H__

#ifdef HAVE_CONFIG_H
#	include "config.h"
#endif /* HAVE_CONFIG_H */

#include <glib.h>
#include "egg-action-group.h"
#include "kz-window.h"
#include "kz-langinfo.h"

G_BEGIN_DECLS

extern EggActionGroupEntry kz_actions_popup[];
extern const gint          kz_actions_popup_len;
extern const LanguageInfo languages[];
extern const gint          n_languages;

EggActionGroup *kz_actions_popup_create_group (KzWindow      *kz,
					       GtkAccelGroup *accel_group);
void            kz_actions_popup_menu_modal   (KzWindow      *kz,
					       guint          button,
					       guint          time);

G_END_DECLS

#endif /* __KZ_ACTIONS_POPUP_H__ */
