/*
 * previewdialog.hh
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __PREVIEWDIALOG_HH__
#define __PREVIEWDIALOG_HH__

#include <gtkmm/dialog.h>
#include <gtkmm/label.h>
#include <gtkmm/spinbutton.h>
#include <gtkmm/adjustment.h>
#include <gtkmm/box.h>
#include <gtkmm/scrolledwindow.h>
#include "print.hh"

class PreviewDialog {
public:
  PreviewDialog(Print&);
  ~PreviewDialog();
  bool run();
  bool ok();

private:
  void recalculate_gui();

  void on_back_clicked();
  void on_rewind_clicked();
  void on_forward_clicked();
  void on_ff_clicked();
  void on_signal_value_changed();

  bool load(int);

  Print& _print;

  Gtk::HBox hbox;
  Gtk::Dialog dialog;
  Gtk::Adjustment adj;
  Gtk::SpinButton pages;
  Gtk::Label label;
  Gtk::ScrolledWindow window;

  Gtk::Button back;
  Gtk::Button forward;
  Gtk::Button rewind;
  Gtk::Button ff;

  Gtk::Image image;
  Glib::RefPtr<Gdk::Pixbuf> pix;
  bool _ok;
};

#endif /* __PREVIEWDIALOG_HH__ */
