/*
 * ps.hh
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __PS_HH__
#define __PS_HH__

#include <sstream>
#include <pango/pangoft2.h>
#include <pangomm/layout.h>
#include <pangomm/context.h>
#include "conf.hh"
#include "tempfile.hh"

class PS : public TempFile {
public:
  PS(Conf&);
  ~PS();
  void add_line(std::string&);
  std::string get_ps() { return ps.str(); }
  int get_pages() { return pages; }

  void set_dimensions(int, int);
  void set_margins(int, int, int, int);
  void set_orientation(int o) { orientation = o; }
  int get_orientation() { return orientation; }
  void init();
  void header();
  void footer();
  bool process(std::string&);

private:
  void draw_line(int, Glib::RefPtr<Pango::LayoutLine>&, PangoDirection);
  void draw_bitmap(FT_Bitmap *, double, double);
  void start_page();
  void end_page();

  Glib::RefPtr<Pango::Context> context;
  Pango::FontDescription font;

  double pt_to_pixel;
  double pixel_to_pt;

  Conf& conf;

  std::stringstream ps;
  int pages;
  int width, height;
  int top, left, right, bottom;
  int dpi_x, dpi_y;
  int text_width, text_height;
  int y_pos;
  int pango_text_height;
  int orientation;
};

#endif /* __PS_HH__ */
