/*
 * katoob.hh
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __KATOOB_HH__
#define __KATOOB_HH__

#include <vector>
#include <gtkmm/main.h>
#include "window.hh"
#include "conf.hh"
#include "encodings.hh"
#ifdef ENABLE_DBUS
#include "dbus.hh"
#endif

class Katoob : public Gtk::Main
#ifdef ENABLE_DBUS
	     , DBus
#endif /* ENABLE_DBUS */
{

public:
  Katoob(int argc, char *argv[]);
  int run();
  void window();

  void quit_cb();
private:
  void parse(int argc, char *argv[]);
  void usage();
  void help();
  void version();
  Encodings encodings;
  Conf conf;
  std::vector<Window *> children;
  std::vector<std::string> files;
};

#endif /* __KATOOB_HH__ */
