/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Praveen Kandikuppa : praveen9@gmail.com                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _KATDAEMONLIST_H_
#define _KATDAEMONLIST_H_

#include <kdialogbase.h>
#include <kat_export.h>

class QVBox;
class KComboBox;

class CatalogStatusItem;
class KatTray;
class KatIndexerManager;

class KAT_EXPORT DlgDaemonStatus : public KDialogBase
{
Q_OBJECT

public:
    DlgDaemonStatus( KatIndexerManager*, QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );

private slots:
    void managerStarted();
    void updateCurrentFile( int, QString );
    void updateProgress( int, int );
    void updateStatus( int, int, QString );
    void updateSubStatus( int, int, QString );
    void changeCatalog( int );
    void slotAddCatalog( int );
    void slotDeleteCatalog( int );

    void startIndexer();
    void pauseIndexer();
    void stopIndexer();

    // Tray slots
    void slotStartAll();
    void slotStopAll();
    void slotPauseAll();
    void slotConfigure();
    void slotShowAbout();
    void slotConfigureNotifications();

    void slotClose();
    void slotUpdateSize();

private:
    KatIndexerManager* m_iManager;

    QVBox* m_box;
    KComboBox* m_catalogCombo;
    CatalogStatusItem* m_statusItem;

    KatTray* tray;

    QValueList<int> m_catalogIds;
    int m_currentCatalogId;

};

#endif // _KATDAEMONLIST_H_
