/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Praveen Kandikuppa : praveen9@gmail.com                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _KATDAEMONEVENTS_H_
#define _KATDAEMONEVENTS_H_

#include <qevent.h>
#include <qvariant.h>
#include <qstring.h>

class PauseEvent : public QCustomEvent
{
public:
    PauseEvent() : QCustomEvent( 9000 ) {};
};

class StopEvent : public QCustomEvent
{
public:
    StopEvent() : QCustomEvent( 9001 ) {};
};

class ResumeEvent : public QCustomEvent
{
public:
    ResumeEvent() : QCustomEvent( 9002 ) {};
};

class StatusEvent : public QCustomEvent
{
public:
    StatusEvent( const int& catalogId, const int& status ) : QCustomEvent( 9004 )
    {
        m_status = status;
        m_catalogId = catalogId;
    };

    int catalogId() const { return m_catalogId; };
    int status() const { return m_status; };
private:
    int m_catalogId;
    int m_status;
};

class SubStatusEvent : public QCustomEvent
{
public:
    SubStatusEvent( const int& catalogId, const int& status, const QVariant& data = QVariant() ) : QCustomEvent( 9005 )
    {
        m_status = status;
        m_catalogId = catalogId;
        m_data = data;
    };

    int catalogId() const { return m_catalogId; };
    int status() const { return m_status; };
    QVariant statusData() const { return m_data; };
private:
    int m_catalogId;
    int m_status;
    QVariant m_data;
};

class ProgressEvent : public QCustomEvent
{
public:
    ProgressEvent( const int& catalogId, const int& filesDone, const long& time ) : QCustomEvent( 9015 )
    {
        m_catalogId = catalogId;
        m_filesDone = filesDone;
        m_time = time;
    };

    int catalogId() const { return m_catalogId; };
    int filesDone() const { return m_filesDone; };
    long time() const { return m_time; };

private:
    int m_catalogId;
    int m_filesDone;
    long m_time;
};

class CurrentFileEvent : public QCustomEvent
{
public:
    CurrentFileEvent( const int& catalogId, const QString& file, const int& filesCount ) : QCustomEvent( 9016 )
    {
        m_catalogId = catalogId;
        m_file = file;
        m_filesCount = filesCount;
    };

    int catalogId() const { return m_catalogId; };
    QString file() const { return m_file; };
    int filesCount() const { return m_filesCount; };

private:
    int m_catalogId;
    QString m_file;
    int m_filesCount;
};

class ScheduleEvent : public QCustomEvent
{
public:
    ScheduleEvent( const int& waitTime ) : QCustomEvent( 9021 )
    {
        m_waitTime = waitTime;
    };
    int waitTime() const { return m_waitTime; };

private:
    int m_waitTime;
};

#endif // _KATDAEMONEVENTS_H_
