/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Praveen Kandikuppa : praveen9@gmail.com                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _KATDAEMON_H_
#define _KATDAEMON_H_

#include <kdedmodule.h>

#include "kat_export.h"
#include <qstringlist.h>

class KatIndexerManager;
class DlgDaemonStatus;

class KAT_EXPORT KatDaemon : public KDEDModule
{
    K_DCOP
    Q_OBJECT

public:
    KatDaemon( const QCString& name );
    ~KatDaemon();

k_dcop:
    void reInitialize();
    void updateCatalogs();
    bool addCatalog( int );
    bool deleteCatalog( int );
    bool updateCatalog( int );

    void setIdleLoad( int );
    int idleLoad() const;
    void setMaxWait( int _wait );
    int maxWait() const;

    void changeIdleLoadMaxWait( int load,  int _wait, QStringList lstFolder, QStringList lstFile );

    QStringList listOfCatalog();

    QStringList excludeFolderList();
    QStringList excludeFilesList();

    void setExcludeFolderList( QStringList lst);
    void setExcludeFilesList( QStringList lst);

private:
    KatIndexerManager* m_iManager;
    DlgDaemonStatus* m_daemonStatus;
};

#endif // _KATDAEMON_H_
