/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _DLGSEARCH_H
#define _DLGSEARCH_H

#include <qvariant.h>
#include <qwidget.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QSpacerItem;
class QSplitter;
class QTabWidget;
class QLabel;
class QButtonGroup;
class QCheckBox;
class KPushButton;
class KLineEdit;
class KIconButton;
class KTextEdit;

class DlgSearch : public QWidget
{
    Q_OBJECT

public:
    DlgSearch( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~DlgSearch();

public slots:
    void simpleStartSearch();
     void simpleLimitSearch();
     void simpleConfigure();
     void advancedStartSearch();
     void criteriaAnd();
     void criteriaOr();
     void criteriaXor();
     void criteriaNot();
     void criteriaParenthesisOpen();
     void criteriaParenthesisClose();
     void criteriaInsert();
     void criteriaModify();
     void criteriaValidate();
     void advancedLimitSearch();
     void advancedConfigure();
     void criteriaOptions();

protected slots:
    void slotTextChanged(const QString& );

private:
    QLabel* tlSearch;
    QCheckBox* cbFilenames;
    QCheckBox* cbDescriptions;
    QCheckBox* cbFullTexts;
    KPushButton* pbLimitSimpleSearch;
    KPushButton* pbConfigureSimple;
    KLineEdit* leSearchText;
    KPushButton* ibStartSimpleSearch;
    KPushButton* pbLimitAdvancedSearch;
    KPushButton* pbOptions;
    KPushButton* pbValidate;
    KPushButton* pbModify;
    KPushButton* pbAnd;
    KPushButton* pbOr;
    KPushButton* pbXor;
    KPushButton* pbNot;
    KPushButton* pbParenthesisOpen;
    KPushButton* pbParenthesisClose;
    KTextEdit* teCriteria;
    KPushButton* pbConfigureAdvanced;
    KPushButton* ibStartAdvancedSearch;
    KPushButton* pbInsert;

};

#endif // _DLGSEARCH_H_
