/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <klocale.h>
#include <kglobal.h>
#include <qvariant.h>
#include <qtabwidget.h>
#include <qwidget.h>
#include <qlabel.h>
#include <kprogress.h>
#include <qbuttongroup.h>
#include <kicondialog.h>
#include <ktextedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qeventloop.h>
#include <qapplication.h>
#include <kapplication.h>
#include <kmessagebox.h>
#include <kdebug.h>
#include <qtimer.h>

#include <katengine.h>

#include "dlgcreatecatalog.h"
#include "dlgmainwindow.h"
#include "katutils.h"

#include <katinfoextractor.h>
#include <katscanfolder.h>

DlgCreateCatalog::DlgCreateCatalog( DlgMainWindow* parent, const char* name, bool modal )
    : KDialogBase( parent, name, modal, i18n( "Creation of Catalog" ) , KDialogBase::Ok|KDialogBase::Cancel|KDialogBase::Help, KDialogBase::Ok, true )
{
    mf = parent;
    m_ke = mf->katEngine();
    m_cat = mf->cat();

    QWidget *page = new QWidget( this );
    setMainWidget(page);

    QVBoxLayout *DlgCreateCatalogLayout = new QVBoxLayout( page, 11, 6, "DlgCreateCatalogLayout" );

    tabWidget = new QTabWidget( page, "tabWidget" );

    QWidget *tStatus = new QWidget( tabWidget, "tStatus" );

    QVBoxLayout *layout1 = new QVBoxLayout( tStatus, KDialog::marginHint(), KDialog::spacingHint(), "layout1" );

    tlMessage = new QLabel( tStatus, "tlMessage" );
    tlMessage->setAlignment( int( QLabel::AlignCenter ) );
    tlMessage->setText( i18n( "The specified folder is being scanned.\nPlease wait." ) );
    layout1->addWidget( tlMessage );

    pProgress = new KProgress( tStatus, "pProgress" );
    pProgress->setPercentageVisible( false );
    pProgress->setTotalSteps( 0 );
    pProgress->setProgress( 0 );
    pProgress->setTextEnabled( false );
    pProgress->setFormat( QString::null );
    layout1->addWidget( pProgress );

    tlTimeFromStart = new QLabel( tStatus, "tlTimeFromStart" );
    tlTimeFromStart->setAlignment( int( QLabel::AlignCenter ) );
    tlTimeFromStart->setText( QString::null );
    layout1->addWidget( tlTimeFromStart );

    bgStats = new QButtonGroup( tStatus, "bgStats" );
    bgStats->setTitle( i18n( "Analyzed" ) );
    layout1->addWidget( bgStats );

    QVBoxLayout *layout3=new QVBoxLayout( bgStats, KDialog::marginHint(), KDialog::spacingHint(), "layout3" );

    QGridLayout *grid1 = new QGridLayout( 0, 2, 4 , KDialog::marginHint(), KDialog::spacingHint(), "grid1" );

    tlFiles = new QLabel( bgStats, "tlFiles" );
    tlFiles->setText( i18n( "Files" ) );
    grid1->addWidget( tlFiles,0,0 );

    tlFilesNum = new QLabel( bgStats, "tlFilesNum" );
    tlFilesNum->setAlignment( Qt::AlignRight );
    tlFilesNum->setText( QString::null );
    tlFilesNum->setFrameStyle( QFrame::StyledPanel | QFrame::Plain );
    tlFilesNum->setLineWidth( 1 );
    grid1->addWidget( tlFilesNum,1,0 );

    tlFolders = new QLabel( bgStats, "tlFolders" );
    tlFolders->setText( i18n( "Folders" ) );
    grid1->addWidget( tlFolders,0,1 );

    tlFoldersNum = new QLabel( bgStats, "tlFoldersNum" );
    tlFoldersNum->setAlignment( Qt::AlignRight );
    tlFoldersNum->setText( QString::null );
    tlFoldersNum->setFrameStyle( QFrame::StyledPanel | QFrame::Plain );
    grid1->addWidget( tlFoldersNum,1,1 );

    tlArchives = new QLabel( bgStats, "tlArchives" );
    tlArchives->setText( i18n( "Archives" ) );
    grid1->addWidget( tlArchives,0,2 );

    tlArchivesNum = new QLabel( bgStats, "tlArchivesNum" );
    tlArchivesNum->setAlignment( Qt::AlignRight );
    tlArchivesNum->setText( QString::null );
    tlArchivesNum->setFrameStyle( QFrame::StyledPanel | QFrame::Plain );
    grid1->addWidget( tlArchivesNum,1,2 );

    tlFileSize = new QLabel( bgStats, "tlFileSize" );
    tlFileSize->setText( i18n( "File size" ) );
    grid1->addWidget( tlFileSize,0,3 );

    tlFileSizeNum = new QLabel( bgStats, "tlFileSizeNum" );
    tlFileSizeNum->setAlignment( Qt::AlignRight );
    tlFileSizeNum->setText( QString::null );
    tlFileSizeNum->setFrameStyle( QFrame::StyledPanel | QFrame::Plain );
    grid1->addWidget( tlFileSizeNum,1,3 );

    layout3->addLayout( grid1 );

    grid1 = new QGridLayout( 0, 4, 2, "Grid2" );

    tlWords = new QLabel( bgStats, "tlWords" );
    tlWords->setText( i18n( "Words imported:" ) );
    grid1->addWidget( tlWords, 0, 0 );

    tlWordsNum = new QLabel( bgStats, "tlWordsNum" );
    tlWordsNum->setAlignment( Qt::AlignRight );
    tlWordsNum->setText( QString::null );
    grid1->addWidget( tlWordsNum, 0, 1 );

    tlMetaData = new QLabel( bgStats, "tlMetaData" );
    tlMetaData->setText( i18n( "Metadata imported:" ) );
    grid1->addWidget( tlMetaData, 1, 0 );

    tlMetaDataNum = new QLabel( bgStats, "tlMetaDataNum" );
    tlMetaDataNum->setAlignment( QLabel::AlignRight );
    tlMetaDataNum->setText( QString::null );
    grid1->addWidget( tlMetaDataNum, 1, 1 );

    tlFullTexts = new QLabel( bgStats, "tlFullTexts" );
    tlFullTexts->setText( i18n( "Fulltexts imported:" ) );
    grid1->addWidget( tlFullTexts, 2, 0 );

    tlFullTextsNum = new QLabel( bgStats, "tlFullTextsNum" );
    tlFullTextsNum->setAlignment( QLabel::AlignRight );
    tlFullTextsNum->setText( QString::null );
    grid1->addWidget( tlFullTextsNum, 2, 1 );

    tlThumbnails = new QLabel( bgStats, "tlThumbnails" );
    tlThumbnails->setText( i18n( "Thumbnails imported:" ) );
    grid1->addWidget( tlThumbnails, 3, 0 );

    tlThumbnailsNum = new QLabel( bgStats, "tlThumbnailsNum" );
    tlThumbnailsNum->setAlignment( QLabel::AlignRight );
    tlThumbnailsNum->setText( QString::null );
    grid1->addWidget( tlThumbnailsNum, 3, 1 );
    layout3->addLayout( grid1 );

    tabWidget->insertTab( tStatus, i18n( "Status" ) );

    QWidget *tDetails = new QWidget( tabWidget, "tDetails" );
    QVBoxLayout *layout2 = new QVBoxLayout( tDetails, KDialog::marginHint(), KDialog::spacingHint(), "layout2" );

    teDetails = new KTextEdit( tDetails, "teDetails" );
    QFont teDetails_font(  teDetails->font() );
    //TODO use font from KDE
    teDetails_font.setFamily( "Monospace" );
    teDetails->setFont( teDetails_font );
    tabWidget->insertTab( tDetails, i18n( "Details" ) );
    layout2->addWidget( teDetails );

    DlgCreateCatalogLayout->addWidget( tabWidget );

    resize( QSize(560, 460).expandedTo( minimumSizeHint() ) );
    clearWState( WState_Polished );

    // timers
    QTimer::singleShot(0, this, SLOT( slotStartScan() ) );

    updateTimer = new QTimer( this );
    updateTimer->start( 300 );
    connect( updateTimer, SIGNAL( timeout() ), SLOT( slotUpdateScanDialog() ) );
    enableButton( KDialogBase::Help, false );
}

DlgCreateCatalog::~DlgCreateCatalog()
{
}

void DlgCreateCatalog::slotStartScan()
{
    m_start.start();
    enableButtonOK( false );

    m_ksf = m_ke->scanFolder( m_cat );
    connect( m_ksf, SIGNAL( completed() ), this, SLOT( scanCompleted() ) );
    connect( this, SIGNAL( aborted() ), m_ksf, SLOT( slotScanAborted() ) );
}

void DlgCreateCatalog::slotCancel()
{
    kdDebug() << "abort emitted" << endl;
    emit aborted();
    done( QDialog::Rejected );
}

void DlgCreateCatalog::slotUpdateScanDialog()
{
    pProgress->setProgress( pProgress->progress() + 1 );

    int etime = m_start.elapsed();
    unsigned int seconds = etime/1000;

    QString folders = QString::number( m_cat->folders() );
    addSeparators( folders );

    QString files = QString::number( m_cat->files() );
    addSeparators( files );

    QString fileSize = QString::number( m_cat->fileSize() );
    addSeparators( fileSize );

    tlTimeFromStart->setText( katConvertSeconds( seconds ) );

    tlFoldersNum->setText( folders );
    tlFilesNum->setText( files );
    tlFileSizeNum->setText( fileSize );
}

void DlgCreateCatalog::slotUpdateExtractDialog()
{
    pProgress->setProgress( m_cat->extractions() );

    int etime = m_start.elapsed();
    int seconds = etime/1000;

    QString metadata = QString::number( m_cat->metaData() );
    addSeparators( metadata );

    QString thumbnails = QString::number( m_cat->thumbnails() );
    addSeparators( thumbnails );

    QString fulltexts = QString::number( m_cat->fullTexts() );
    addSeparators( fulltexts );

    QString words = QString::number( m_cat->words() );
    addSeparators( words );

    tlTimeFromStart->setText( katConvertSeconds( seconds ) );

    tlMetaDataNum->setText( metadata );
    tlThumbnailsNum->setText( thumbnails );
    tlFullTextsNum->setText( fulltexts );
    tlWordsNum->setText( words );
}

void DlgCreateCatalog::scanCompleted()
{
    // if the scan has been too quick to display the stats,
    // display them now (it happens in presence of few files)
    slotUpdateScanDialog();

    // disconnect ksf from SIGNAL aborted()
    disconnect( this, SIGNAL( aborted() ) );

    updateTimer->stop();

    updateTimer = new QTimer( this );
    updateTimer->start( 300 );
    connect( updateTimer, SIGNAL( timeout() ), SLOT( slotUpdateExtractDialog() ) );

    pProgress->setTotalSteps( m_cat->files() * 3 ); // *3 = previews, metadata, fulltexts
    pProgress->setProgress( 0L );
    pProgress->setTextEnabled( true );
    pProgress->setFormat( "%p%" );

    m_kie = m_ke->extractInfo( m_cat );
    connect( m_kie, SIGNAL( completed() ), this, SLOT( extractionCompleted() ) );
    connect( this, SIGNAL( aborted() ), m_kie, SLOT( slotExtractionAborted() ) );
}

void DlgCreateCatalog::extractionCompleted()
{
    updateTimer->stop();
    pProgress->setProgress( m_cat->files() * 3 );

    m_ke->updateCatalog( m_cat );

    enableButtonOK( true );
    enableButtonCancel( false );
    KMessageBox::information( this, i18n( "Done!" ) );
}

#include "dlgcreatecatalog.moc"
