/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Laurent Montel : montel@kde.org                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <kstandarddirs.h>
#include <kdebug.h>
#include <kmimetype.h>
#include <kfilterdev.h>
#include <kzip.h>
#include <qregexp.h>

#include "fulltext_gnumeric.h"

extern "C"
{
    KAT_EXPORT FulltextExtractor* new_extractor( const QString& path )
    {
        return new GnumericExtractor( path );
    }
}


GnumericExtractor::GnumericExtractor( const QString &path ) :
    m_bDone( false ),
    m_path( path )
{
}

GnumericExtractor::~GnumericExtractor()
{
}

void GnumericExtractor::extract( QString& data ) {

    kdDebug() << "GnumericExtractor start" << endl;

    if ( m_bDone ) {
        data = QString::null;
        return;
    }
    m_bDone = true;

    QIODevice* dev = KFilterDev::deviceForFile( m_path, "application/x-gzip" );
    if ( !dev )
    {
        kdError() << "Cannot create device for uncompressing! Aborting!" << endl;
        delete dev;
        return;
    }
    if ( !dev->open( IO_ReadOnly ) )
    {
        kdError() << "Cannot open file for uncompressing! Aborting!" << endl;
        delete dev;
        return;
    }

    QByteArray BA = dev->readAll();
    QString d( BA );

    dev->close();
    //delete dev;

    d = d.replace( QRegExp( "<[^>]*>" ), " " ); // strip all XML tags
    d = d.simplifyWhiteSpace();

    QTextOStream stream( &data );
    stream << "<fulltext>";
    stream << d;
    stream << "</fulltext>";

    kdDebug() << "GnumericExtractor end" << endl;
}

