
import os
import kirbybase
import kb_utils
from HTMLTags import *
import md5

db=kirbybase.KirbyBase('client','localhost',44444)

[[imports]]

table = '%s.tbl' %name
table = table.replace('\\','\\\\')

if not os.path.exists(table):
    db.create(table,fields)

field_names = kb_utils.field_names(fields)

def index():
    if security != "low" and not users:
        error("Error in configuration : if security is not low, a users "
            "database must be defined in the configuration file")
    user_test = (security == "low") # default
    Include(headerUrl,title=pageTitle)
    print H1(pageTitle)
    if users:
        user_id = None
        so = Session()
        if hasattr(so,'%s_user' %name):
            user_id = getattr(so,'%s_user' %name)
            user = db.select('%s.tbl' %users,['recno'],[user_id],returnType='object')[0]
            print user.login
            print BR(A("Logout",href="logout"))
            user_test = True
        else:
            print A("Login",href="login?base=%s" %users)
        print P()
    if security == "high" and not user_test:
        print "You are not allowed to see the base"
    else:
        records=db.select(table,["recno"],["*"],returnType='dict')
        if records:
            print '<table class="main" cellpadding="3" cellspacing="0">'
            print '<tr>'
            print Sum([TH(f) for f in field_names])
            if user_test:
                print TH('&nbsp;')*2
            print '</tr>\n'
            for record in records:
                print '<tr>'
                [[print records]]
                if user_test:
                    print TD(A('Remove',
                        href="removeRecord?recordId=%s" %record['recno']),
                        Class="main")
                    print TD(A('Edit',
                        href="editRecord?recordId=%s" %record['recno']),
                        Class="main")
                print '</tr>'
            print '</table>'
        else:
            print "Empty base"

    if user_test:
        print '<p><a href="editRecord?recordId=-1">New record</a>'
    print '</body>\n</html>'

def editRecord(recordId):
    recordId=int(recordId)
    if recordId>-1:
        record=db.select(table,["recno"],[recordId],returnType='dict')[0]
        Include(headerUrl,title="Editing record %s" %recordId)
        print "<h1>Editing a record</h1>"
    else:
        Include(headerUrl,title="New record")
        print "<h1>New record</h1>"
        record=dict([(f,'') for f in field_names])
    
    print '<form action="insertRecord">'

    print '<input type="hidden" name="recordId" value="%s">' %recordId
    print '<table>'
    [[input records]]
    print '</table>'
    print '<input type="submit" value="Ok">'
    print '</form>'
    print '</body>\n</html>'

def insertRecord(recordId,**untyped_fields):
    try:
        typed_fields = kb_utils.conv_rec(fields,**untyped_fields)
    except ValueError,msg:
        error(msg)
        raise SCRIPT_END
    recordId=int(recordId)
    if recordId==-1:
        db.insert(table,typed_fields)
    else:
        db.update(table,["recno"],[recordId],typed_fields)
    db.pack(table)
    raise HTTP_REDIRECTION,"index"

def removeRecord(recordId):
    db.delete(table,["recno"],[int(recordId)])
    db.pack(table)
    raise HTTP_REDIRECTION,"index"

def login(base):
    print H1("Login")
    print '<form action="check_login" method="post">'
    print INPUT(name="base",Type="hidden",value=base)
    print TABLE(
        TR(TD("Login")+TD(INPUT(name="login"))) +
        TR(TD("Password")+
            TD(INPUT(name="password", Type="password"))) +
        TR(TD(INPUT(Type="submit",value="Ok"))+
            TD("&nbsp;"))
        )
    print '</form>'

def check_login(**user_data):
    base = user_data['base']
    try:
        user_record = db.select('%s.tbl' %base,['login'],[user_data['login']],
            returnType = 'object')
    except kirbybase.KBError,msg:
        print "An error occured when checking login info"
        print P(msg)
        print P(A("Back",href="index"))
        raise SCRIPT_END
    if not user_record:
        print "Unknown user"
        print P(A("Back",href="index"))
    else:
        record = user_record[0]
        if user_data['password']==record.password:
            setattr(Session(),'%s_user' %name, record.recno)
            raise HTTP_REDIRECTION,'index'
        else:
            print "Unknown user"
            print P(A("Back",href="index"))        

def logout():
    Session().close()
    raise HTTP_REDIRECTION,'index'

def error(msg):
    Include(headerUrl,title=pageTitle)
    print H1(pageTitle)
    print msg
    print P(A('Back',href='index'))
