
import os
import kirbybase
import kb_utils
from HTMLTags import *
import md5

name = "loan"
fields = ['book_id:int', 'student_id:int', 'loan_date:datetime.date']
pageTitle = "Table loan"
table = r"c:\\cygwin\\home\\QUENTEL\\data\\loan.tbl"
users = r"c:\\cygwin\\home\\QUENTEL\\data\\students_loan_books_users.tbl"
admin_file = r"c:\cygwin\home\QUENTEL\data\students_loan_books.ini"
db=kirbybase.KirbyBase('client','localhost',44444)
if not os.path.exists(table):
    db.create(table,fields)

field_names = kb_utils.field_names(fields)
header=HEAD(LINK(rel="stylesheet",href="../default.css") +
    TITLE(pageTitle))

def index():
    user_test = False # default
    print '<html>\n'
    print header
    print H1(pageTitle)

    user_id = None
    so = Session()
    if hasattr(so,'%s_user' %name):
        user_id = getattr(so,'%s_user' %name)
        user = db.select(users,['recno'],[user_id],returnType='object')[0]
        print user.login
        print BR(A("Logout",href="logout"))
        user_test = True
    else:
        print A("Login",href="login")
    print P()

    records=db.select(table,["recno"],["*"],returnType='dict')
    if records:
        print '<table class="main" cellpadding="3" cellspacing="0">'
        print '<tr>'
        print Sum([TH(f) for f in field_names])
        if user_test:
            print TH('&nbsp;')*2
        print '</tr>\n'
        counter = 0
        for record in records:
            counter+=1
            if counter % 2:
                print '<tr class="even">'
            else:
                print '<tr class="odd">'
            print TD(record["book_id"])
            print TD(record["student_id"])
            print TD(record["loan_date"])
            if user_test:
                print TD(A('Remove',
                    href="removeRecord?recordId=%s" %record['recno']),
                    Class="main")
                print TD(A('Edit',
                    href="editRecord?recordId=%s" %record['recno']),
                    Class="main")
            print '</tr>'
        print '</table>'
    else:
        print "Empty base"

    if user_test:
        print '<p><a href="editRecord?recordId=-1">New record</a>'
    print '</body>\n</html>'

def editRecord(recordId):
    recordId=int(recordId)
    if recordId>-1:
        record=db.select(table,["recno"],[recordId],returnType='dict')[0]
        print header
        print H1("Editing a record")
    else:
        print header
        print H1("New record")
        record=dict([(f,'') for f in field_names])
    
    print '<form action="insertRecord">'

    print INPUT(type="hidden",name="recordId",value=recordId)
    print '<table>'
    print TR(TD("book_id")+TD(INPUT(name="book_id",size="40",value=record["book_id"])))
    print TR(TD("student_id")+TD(INPUT(name="student_id",size="40",value=record["student_id"])))
    print TR(TD("loan_date")+TD(INPUT(name="loan_date",size="40",value=record["loan_date"])))
    print '</table>'
    print INPUT(type="submit",value="Ok")
    print '</form>'
    print '</body>\n</html>'

def insertRecord(recordId,**untyped_fields):
    try:
        typed_fields = kb_utils.conv_rec(fields,**untyped_fields)
    except ValueError,msg:
        error(msg)
        raise SCRIPT_END
    recordId=int(recordId)
    if recordId==-1:
        db.insert(table,typed_fields)
    else:
        db.update(table,["recno"],[recordId],typed_fields)
    db.pack(table)
    raise HTTP_REDIRECTION,"index"

def removeRecord(recordId):
    db.delete(table,["recno"],[int(recordId)])
    db.pack(table)
    raise HTTP_REDIRECTION,"index"

def login():
    print H1("Login")
    print '<form action="check_login" method="post">'
    print TABLE(
        TR(TD("Login")+TD(INPUT(name="login"))) +
        TR(TD("Password")+
            TD(INPUT(name="password", Type="password"))) +
        TR(TD(INPUT(Type="submit",value="Ok"))+
            TD("&nbsp;"))
        )
    print '</form>'

def check_login(**user_data):
    try:
        user_record = db.select(users,['login'],[user_data['login']],
            returnType = 'object')
    except kirbybase.KBError,msg:
        print "An error occured when checking login info"
        print P(msg)
        print P(A("Back",href="index"))
        raise SCRIPT_END
    if not user_record:
        print "Unknown user"
        print P(A("Back",href="index"))
    else:
        record = user_record[0]
        if user_data['password']==record.password:
            setattr(Session(),'%s_user' %name, record.recno)
            raise HTTP_REDIRECTION,'index'
        else:
            print "Unknown user"
            print P(A("Back",href="index"))        

def logout():
    Session().close()
    raise HTTP_REDIRECTION,'index'
    
def error(msg):
    print header
    print H1(pageTitle)
    print msg
    print P(A('Back',href='index'))


def admin():
    raise HTTP_REDIRECTION, '../%s_users.ks/index' %name
