"""Karrigell templating

Written by Pierre Quentel quentel.pierre@wanadoo.fr
Refactored by Didier Wenzek didier.wenzek@free.fr
(Code moved from Karrigell.py)

Published under the GPL licence - no warranty, used at user's risk etc. See
http://www.gnu.org/copyleft/gpl.html and LICENCE.txt
"""

import sys, os, urlparse, copy, cStringIO, traceback, imp
import urllib, gettext, cgi, tokenize

import PythonInsideHTML, HIP, URLResolution, debugger.k_debugger, k_utils
import k_config

from k_script import BaseScript, Output, ParseError

# import modules to handle scripts
handled_extensions = []
for f in os.listdir(k_config.serverDir):
    if f.startswith('mod_') and f.endswith('.py'):
        module_name = os.path.splitext(f)[0]
        handled_extensions.append(module_name[4:].lower())
        exec('import %s' %module_name)

class RecursionError(Exception):

    def __init__(self,tree):
        self.tree=tree

    def __str__(self):
        """Return a tree-like view of the recursion problem"""
        return self.tree[0].name+"".join([ "\n"+" "*i+" includes "+s.name \
            for (i,s) in enumerate(self.tree[1:])])

def list_directory(path,dirName):
    script = getScript('listDirectory.pih')
    return script.render({'path':path,'dirName':dirName,
        'serverDir':k_config.serverDir,
        'allow':k_config.allow_directory_listing}).value
    
def execScript(fileName, **args):
    """Runs the script and all the included scripts.
    Sends its output on current standard output"""
    ExecContext(getScript(fileName), args)()

def getScript(fileName):
    """Returns the Script instance matching filename"""
    base,extension=os.path.splitext(fileName)
    extension=extension[1:].lower()
    module = sys.modules['mod_%s' %extension]
    script = module.Script(fileName)
    script.extension=extension
    return script
        
class ExecContext:
    def __init__(self, script, nameSpace, path='',requestHandler=None):
        self.script = script
        self.nameSpace = copy.copy(nameSpace)
        self.nameSpace['Include'] = self.Include
        self.nameSpace['THIS']=script
        self.stack = []
        self.output = []
        self.path = path
        self.requestHandler=requestHandler

    def __call__(self):
        # save initial namespace for cleanup before execution
        self.stack = [self.script]
        output=self.script.render(self.nameSpace)
        self.output.append(output)
        self.stack = []
        errors = [ out for out in self.output if not out.status ]
        # if error in one of the scripts, only print the trace of this script
        if errors:
            output=errors[0]
        return str(output)

    def getCurrentScript(self):
        if len(self.stack): return self.stack[-1]
        else: return self.script

    def Include(self,includedUrl,**args):
        """Include a document inside the current script output
        The other document is searched in current script directory
        If it's a script, it is run in the same namespace as the script ; if
        additional args are supplied they are added to the namespace
        If it's a plain document its content is sent to the standard output
        """
        url=urlparse.urljoin(self.path,includedUrl)
        url_without_qs,qs=URLResolution.split_query(url)
        qs=k_utils.applyQueryConvention(qs)
        args.update(qs)
        fileName=URLResolution.translate_path(url_without_qs)
        if not fileName:
            raise IOError
        if os.path.isdir(fileName):
            # search an index file
            # if no one or more than one is found, an exception is raised
            indexFile=URLResolution.indexFile(fileName)
            fileName=os.path.join(fileName,indexFile)
            if url.endswith("/"):
                url=urlparse.urljoin(url,indexFile)
            else:
                url=urlparse.urljoin(url+"/",indexFile)
        elif not os.path.exists(fileName):
            # search for a file with name fileName.ext
            # with extension in htm, html, py, pih, hip, ks
            # if no one or more than one is found, an exception is raised
            ext=URLResolution.search(url_without_qs,fileName)
            fileName+=ext
        fileExt=os.path.splitext(fileName)[1][1:]
        if not fileExt.lower() in handled_extensions:
            script=BaseScript(fileName,open(fileName).read(),{})
            output=Output(script,1,script.code)
        else:
            # create a Script object and keep track of the script from which
            # it was called (to localize errors when debugging)
            script=getScript(fileName)
            # set parent and caller attributes for the included script
            script.url=url_without_qs
            script.parent=self.stack[-1]
            
            #script.requestHandler=self.requestHandler
            self.stack.append(script)
            # before execution, chdir to script dir
            saveDir=os.getcwd()
            thisDir=os.path.dirname(fileName)
            os.chdir(thisDir)
            if not thisDir in sys.path:
                sys.path.append(thisDir)
            output=script.render(self.nameSpace,**args)
            os.chdir(saveDir)
            script.loadTranslations(self.nameSpace,saveDir) 
            self.stack.pop()
        sys.stdout.write(str(output))
        self.output.append(output)

if __name__ == '__main__':
    if len(sys.argv) <= 1 :
        print "Usage : python Template.py script"
    else:
        execScript(sys.argv[1])
