/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : mer jun 14 00:26:31 CEST 2000
    copyright            : (C) 2000-2005 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
**
** Projet kArchiveur
** Par Eric Coquelle
** Licence d'utilistaion: GPL
**
**
**	Le projet kArchiveur vise �donner �Linux et KDE un gestionnaire de
**	fichiers compress� digne de ce nom, �la fois puissant et intuitif.
**
**   Ce programme est un logiciel libre; vous pouvez le redistribuer et/ou
**   le modifier selons les conditions de la Licence GNU publi� par la
**   Free Software Foundation; soit la version 2 de la Licence, ou (selon
**   votre pr��ence) toute version ult�ieure.
**
**   Ce logiciel est distibu�avec l'espoir qu'il sera utile, mais SANS
**   AUCUNE GARANTIE; Reportez vous �la Licence GNU pour plus de d�ails.
**
**
 ***************************************************************************/

/***************************************************************************
**
** Project kArchiveur
** By Eric Coquelle
** Under licence : GPL
**
**
**	The goal of the kArchiveur project is to provide Linux and KDE a 
**	compressed files manager, both powerful and intuitive.
**
**
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qdir.h>

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <dcopclient.h>

#include "karchiveur.h"


static const char *description =
	I18N_NOOP("KArchiver for KDE3\nAn easy tool to manage all your compressed files!\nReleased under GPL license");
	

static KCmdLineOptions options[] =
{
  { "+[File]", I18N_NOOP("file to open"), 0 },
  { "x", 0, 0 },
  { "extract <directory>", I18N_NOOP("Extract to the specified directory"), 0},
  { "xe", 0, 0 },
  { "extractgui", I18N_NOOP("Extract and choose directory in a dialog box"), 0},
  { "xh", 0, 0 },
  { "extracthere", I18N_NOOP("Extract to current directory"), 0},
  { "xa", 0, 0 },
  { "extractarchdir", I18N_NOOP("Extract to the directory where the archive is"), 0},
  { "c", 0, 0 },
  { "compress", I18N_NOOP("Make a .tar.gz archive from these files"), 0},
  { "nd", 0, 0 },
  { "withoutdcop", I18N_NOOP("disable DCOP. Some functions may not work!!"), 0},
  { "nw", 0, 0 },
  { "withoutwizard", I18N_NOOP("disable the configuration wizard"), 0},
  { "prefered <compressor_extension>", I18N_NOOP("Set the default compressor when right-clicking a file. Enter one of these extensions: tar, tar.gz, tar.bz2, zip, rar, lha, gz, bz2"), 0},
  { 0, 0, 0 }
};

int main(int argc, char *argv[])
{

	KAboutData aboutData( "karchiver", I18N_NOOP("KArchiver"),
		VERSION, description, KAboutData::License_GPL,
		"(c) 2000-2006, Eric Coquelle","","http://perso.wanadoo.fr/coquelle/karchiver/");
	aboutData.addAuthor("Eric Coquelle",I18N_NOOP("Developer and Maintainer"), "eric a.a coquelle a@a gmail.com","http://perso.wanadoo.fr/coquelle/karchiver/");
	aboutData.addCredit("JP Martin", I18N_NOOP("Bug track and icon designer"), "jeanphilippemartin@club-internet.fr" );
	aboutData.addCredit("L. Montel", I18N_NOOP("Code improvement"), "lmontel@mandrakesoft.com" );
	aboutData.addCredit("P. Korf", I18N_NOOP("Password-protected archive support") );
	aboutData.addCredit("All users for support, reports...");
	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options );

  KApplication app;
  
  if (app.isRestored())
  {
    RESTORE(KarchiveurApp);
  }
  else 
  {
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    
    bool disable_dcop=args->isSet("withoutdcop");
    bool disable_configuration_wizard=args->isSet("withoutwizard");
    
    KarchiveurApp *karchiveur = new KarchiveurApp();

    karchiveur->configurationWizardAndTip(!disable_configuration_wizard);
    karchiveur->show();
    
    if(disable_dcop)
    {
      KApplication::disableAutoDcopRegistration();
      KApplication::dcopClient()->detach();
    }

    if (args->count())
    {
      QStringList strl;
      QCString archivedir;
      KURL url;
      QStringList filestocompress;
      int i;
      
      QCString extractiondirectory = args->getOption("extract");
      bool extract_in_gui = args->isSet("extractgui");
      bool extract_this_dir= args->isSet("extracthere");
      bool extract_archive_dir= args->isSet("extractarchdir");
      bool compress_files=args->isSet("compress");
      QCString preferedcompressor = args->getOption("prefered");

      for(i=0; i<args->count(); i++)
      {
              url=args->url(i);
              strl.append(url.url());
      }

      if(!extractiondirectory.isNull())
              karchiveur->extractFromCommandLine( strl, false, extractiondirectory);
      else if(extract_in_gui)
              karchiveur->extractFromCommandLine( strl, true, "");
      else if(extract_this_dir)
              karchiveur->extractFromCommandLine( strl, false, QCString(QDir::currentDirPath()));
      else if(extract_archive_dir)
              karchiveur->extractFromCommandLine( strl, false, "", true);
      else if(compress_files)
      {
         if(preferedcompressor.left(1)==".")
          preferedcompressor.remove(0,1);
        karchiveur->createArchiveFromCommandLine( strl, preferedcompressor);
      }
      else
        karchiveur->openFileFromCommandLine(strl);
    }
    else
    {
      //karchiveur->openDocumentFile();
    }
    args->clear();
  }

  return app.exec();
}
