/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : DATE                                           
    copyright            : (C) YEAR by AUTHOR                         
    email                : EMAIL                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CWIZARDSTEP1CUTT_H
#define CWIZARDSTEP1CUTT_H

#include <qwidget.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qdialog.h>

#include <kiconloader.h>
#include <kapp.h>
#include <klocale.h>
#include <kwizard.h>
#include <math.h>

/**
  *@author Eric Coquelle
  */

class CWizardCutt : public KWizard  {
   Q_OBJECT
public: 
	CWizardCutt(QWidget *parent=0, const char *name=0);
	~CWizardCutt();

  void setNoneArchiveOpened();
  /** Return the max size of a block of a huge file */
  int getCuttSize() { return spSize->value()*(int)pow(1000,cmbSize->currentItem());};
  QString getRecordDirectory() { return filechoice; };

protected: 
     /* Get the directory where to store the splited files */
    void directoryChoice();
    /* Get the first of the splited files */
    void fileChoice();
    
private:
    void setupPageOne();
    void setupPageTwo();
    
protected slots:
    /** Set an appropriate text to the labels */
    void slotActiveTexte(int);
    void accept();
        
protected: 
    QButtonGroup *QButtonGroup_1;
    QRadioButton *QRadioButton_1;
    QRadioButton *QRadioButton_2;
    QSpinBox *spSize;
    QComboBox *cmbSize;
    QLabel *labelLastStep;
    
private:
    QString filechoice;
};

#endif
