/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : DATE                                           
    copyright            : (C) YEAR by AUTHOR                         
    email                : EMAIL                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "cwizardconversion.h"
#include "resource.h"

#include <kapplication.h>
#include <klocale.h>
#include <qlayout.h>
#include <qdir.h>

CWizardConversion::CWizardConversion(QWidget *parent, const char *name) : KWizard(parent,name){
  
  setupPageOne();
  setupPageTwo();  	
  setupPageThree();
  
  setCaption(i18n("KArchiver conversion wizard"));
}

CWizardConversion::~CWizardConversion(){
}

void  CWizardConversion::setupPageOne(){
  wpageone=new QWidget(this);
  QGridLayout *layout=new QGridLayout(wpageone, 6, 4 );

  QLabel* QLabel_1= new QLabel(wpageone,"WizardPicture");
  QLabel_1->setPixmap(UserIcon("karchiveur_wizard_large"));
  layout->addMultiCellWidget(QLabel_1, 0, 5, 0, 1);

  QLabel* QLabel_2= new QLabel(wpageone,"PageOneConvertText");
  QLabel_2->setText("<qt><h1>"
                    +i18n("Convert archive's format")
                    +"</h1><p>"
                    +i18n("This Wizard will help you to convert the format of your archive, so as to improve the compress rate (for example, .tar.gz to .tar.bz2), or its portability (make a .zip archive from a .tar)")
                    +"</p></qt>");
  layout->addMultiCellWidget(QLabel_2, 0, 4, 2, 3);

 addPage(wpageone, i18n("Convert current archive"));
 setHelpEnabled(wpageone, false);
}

void  CWizardConversion::setupPageTwo(){
  wpagetwo=new QWidget(this);
  QGridLayout* layout=new QGridLayout(wpagetwo, 3, 4 );
  
  QLabel* QLabel_2= new QLabel(wpagetwo,"WizardImage");
  QLabel_2->setPixmap(UserIcon("karchiveur_wizard_large"));
  layout->addMultiCellWidget(QLabel_2, 0, 2, 0, 1);

  QButtonGroup_1= new QButtonGroup(wpagetwo,"NoName");
  QButtonGroup_1->setTitle(i18n("Convert to Format:"));
  layout->addMultiCellWidget(QButtonGroup_1, 0, 2, 2, 3);
  QGridLayout *box=new QGridLayout(QButtonGroup_1, 4, 2, 16, 8);
  
  radiotar= new QRadioButton(QButtonGroup_1,"NoName");
  radiotar->setText(".tar");
  QToolTip::add(radiotar,i18n("Uncompressed"));
  box->addWidget(radiotar, 0, 0);

  radiotargz= new QRadioButton(QButtonGroup_1,"NoName");
  QToolTip::add(radiotargz,i18n("Default UNIX format"));
  radiotargz->setText(".tar.gz");
  box->addWidget(radiotargz, 1, 0);

  radiotarbz2= new QRadioButton(QButtonGroup_1,"NoName");
  QToolTip::add(radiotarbz2,i18n("Best compression ratio"));
  radiotarbz2->setText(".tar.bz2");
  radiotarbz2->setChecked(true);
  box->addWidget(radiotarbz2, 2, 0);

  radiozip= new QRadioButton(QButtonGroup_1,"NoName");
  QToolTip::add(radiozip,"Windows default format");
  radiozip->setText(i18n(".zip"));
  box->addWidget(radiozip, 3, 0);

  radiogz= new QRadioButton(QButtonGroup_1,"NoName");
  QToolTip::add(radiogz,i18n("Only for patches or single file"));
  radiogz->setText(".gz");
  box->addWidget(radiogz, 0, 1);

  radiobz2= new QRadioButton(QButtonGroup_1,"NoName");
  QToolTip::add(radiobz2,i18n("Only for patches or single file"));
  radiobz2->setText(".bz2");
  box->addWidget(radiobz2, 1, 1);

  radiorar= new QRadioButton(QButtonGroup_1,"NoName");
  radiorar->setText(".rar");
  box->addWidget(radiorar, 2, 1);

  radiolha= new QRadioButton(QButtonGroup_1,"NoName");
  radiolha->setText(".lha");
  box->addWidget(radiolha, 3, 1);

  radioarj= new QRadioButton(QButtonGroup_1,"NoName");
  radioarj->setText(".arj");
  box->addWidget(radioarj, 0, 2);

  radio7z= new QRadioButton(QButtonGroup_1,"NoName");
  radio7z->setText(".7z");
  box->addWidget(radio7z, 1, 2);

  radiosit= new QRadioButton(QButtonGroup_1,"NoName");
  radiosit->setText(".sit");
  box->addWidget(radiosit, 2, 2);

  addPage(wpagetwo, i18n("Choose destination format"));
  setHelpEnabled(wpagetwo, false);
}

void  CWizardConversion::setupPageThree(){
  wpagethree=new QWidget(this);
  QGridLayout* layout=new QGridLayout(wpagethree, 2, 2);
  
  QLabel* QLabel_3= new QLabel(wpagethree,"WizardImage");
  QLabel_3->setPixmap(UserIcon("karchiveur_wizard_large"));
  layout->addMultiCellWidget(QLabel_3, 0, 1, 0, 0);
  
  QLabel* text=new QLabel(wpagethree, "textpagethree");
  text->setText(i18n("Please choose a directory where to store your archive"));
  layout->addWidget(text, 0, 1);
  
  treeview = new KFileTreeView(wpagethree, "treeview");
  treeview->addColumn(i18n("Pick a directory below:"));
  KFileTreeBranch* branchhome = new KFileTreeBranch(treeview, KURL(QDir::homeDirPath()), "Home", SmallIcon("folder_home"), false);
  KFileTreeBranch* branch = new KFileTreeBranch(treeview, KURL(QDir::rootDirPath()), "/", SmallIcon("folder_red"), false);
  
  layout->addWidget(treeview, 1, 1);
  
  treeview->addBranch( branchhome );
  treeview->setDirOnlyMode(branchhome, true);
  branchhome->setOpen(true);
  treeview->addBranch( branch );
  treeview->setDirOnlyMode(branch, true);
  branch->setOpen(true);
  
  addPage(wpagethree, i18n("Please choose a directory where to store the archive"));
  setHelpEnabled(wpagethree, false);
  setFinishEnabled(wpagethree, true);
}

void CWizardConversion::accept()
{
  if(radiotar->isChecked())
      newarchivetype=TAR;
  else if(radiotargz->isChecked())
      newarchivetype=TARGZ;
  else if(radiotarbz2->isChecked())
      newarchivetype=TARBZ2;
  else if(radiozip->isChecked())
      newarchivetype=ZIP;
  else if(radiogz->isChecked())
      newarchivetype=GZIP;
  else if(radiobz2->isChecked())
      newarchivetype=BZIP2;
  else if(radiorar->isChecked())
      newarchivetype=RAR;
  else if(radiolha->isChecked())
      newarchivetype=LHA;
  else if(radioarj->isChecked())
    newarchivetype=ARJ;
  else if(radio7z->isChecked())
    newarchivetype=SEVENZ;
  else if(radiosit->isChecked())
    newarchivetype=SIT;
  
  selectedpath = treeview->currentURL().path();
  QDialog::accept();
}

#include "cwizardconversion.moc"

